animals = {};


function onPlayerCommand(event)
	-- Split the command string
	local cmd = StringUtils:explode(event.command, " ");
	cmd[1] = string.lower(cmd[1]);
	
	if #cmd >= 2 and cmd[1] == "/catch" then
		-- mark position
		if cmd[2] == "home" then
			local buf = {}
			local name = event.player:getPlayerName()
			local position = event.player:getPlayerPosition()	
			buf["x"] = position.x
			buf["y"] = position.y
			buf["z"] = position.z
		
			animals[name] = buf
		
			print("npc target postion for " .. name .. " set to: X: " .. position.x .. " Y: " .. position.y .. " Z: " .. position.z )
			event.player:sendTextMessage("New animal home set to: X: " .. position.x .. " Y: " .. position.y .. " Z: " .. position.z)
	
	
		elseif cmd[2] == "done" then
			if not animals[event.player:getPlayerName()] then return false end
			animals[event.player:getPlayerName()] = nil
			event.player:sendTextMessage("Unset animal home")
		end
	end
end
addEvent("PlayerCommand", onPlayerCommand);

function onNpcHit(event)
	
	if animals[event.player:getPlayerName()] then
		local name = event.player:getPlayerName()
		local animalid = event.targetNpc:getNpcID()
		print(name .. " cought animal " .. animalid)
		-- teleport Npc
		event.targetNpc:setNpcPosition(animals[name]["x"], animals[name]["y"], animals[name]["z"])
		event.targetNpc:setNpcHealth(100)
		event.player:sendTextMessage("Animal " .. animalid .. " cought")
		
	end
end
addEvent("NpcHit", onNpcHit);

function onEnable()
    print("Animalcatcher loaded");
end
