-- G P S  script for Rising World
-- Displays world position and heading of the player according to common navigation practices
--
-- database.lua: database and player local cache management
--
-- (C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
-- Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

--
-- dbInit()
--
-- Initialises the DB. Can be run at each script startup without destroying existing data

function dbInit()
	database:queryupdate(
		"CREATE TABLE IF NOT EXISTS `waypoints` ( \
			`player_name` CHAR(64) NOT NULL DEFAULT ('[NoName]'), \
			`wp_name`     CHAR(64) NOT NULL DEFAULT ('[NoName]'), \
			`wp_id`       INTEGER  NOT NULL, \
			`wp_x`        INTEGER  NOT NULL DEFAULT ( 0 ), \
			`wp_y`        INTEGER  NOT NULL DEFAULT ( 0 ), \
			`wp_z`        INTEGER  NOT NULL DEFAULT ( 0 ), \
			PRIMARY KEY (player_name, wp_id) \
		);")
end

--
-- dbLoadPlayer(player)
--
-- Loads from the DB the Homw/wp data for a player and caches them in player attributes

function dbLoadPlayer(player)
	local	count		= 0
	local	result		= database:query("SELECT * FROM `waypoints` WHERE `player_name` = '" .. player:getName() .. "' ORDER BY `wp_id`;")
	local	waypoints	= {}
	while result:next() do
		waypoints[result:getInt("wp_id")] = {
			name	= result:getString("wp_name"),
			x		= result:getFloat("wp_x"),
			y		= result:getFloat("wp_y"),
			z		= result:getFloat("wp_z")
		}
	end
	player:setAttribute(key_gpsWaypoints, waypoints)
end

--
-- dbSetWp(player, wpIndex, wpName)
--
-- Inserts into the DB (or replace if already present) data for a waypoint,
-- also updating the player attribute cache

function dbSetWp(player, wpIndex, wpName)
	local playerName	= player:getName()
	local playerPos		= player:getPosition()
	-- update DB
	database:queryupdate(
		"INSERT OR REPLACE INTO waypoints (player_name,wp_name,wp_id,wp_x,wp_y,wp_z) VALUES ('"
			..playerName.."','"..wpName.."',"..wpIndex..","..playerPos.x..","..playerPos.y..","..playerPos.z..");"
	)
	-- update player cache
	player:getAttribute(key_gpsWaypoints)[wpIndex] = {name = wpName, x = playerPos.x, y = playerPos.y, z = playerPos.z }

	if wpIndex == 0 then
		player:sendTextMessage(msg_homeSet)
	else
		player:sendTextMessage(string.format(msg_wpSet, wpIndex, wpName))
	end
end

function dbSetHome(player)
	dbSetWp(player, 0, txt_homeName)
end
