-- T E L e v a t o r 
-- Implements elevators via teleporting
--
-- (C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
-- Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)
-- Portions of code adapted from Yahgiggle and RichieS' "Portals" script

--------------------
-- G L O B A L S
--------------------
-- Settings
adminsOnly			= false				-- whether only admins can manage elevators
config				= getProperty("config.properties")

-- Attribute keys
key_elevatorsShown	= "elevatorShown"

database			= getDatabase()
scriptVersion		= 0.1
elevators			= {}				-- stores the defined elevators
levels				= {}				-- stores the defined levels/floors for each elevator

-- INCLUDE - after globals are defined
include("messages.lua")				-- include before any other include
include("commands.lua")
include("database.lua")
include("levels.lua")


--------------------
-- E V E N T S
--------------------

-- onEnable()
--
-- called at script loading. Required for the script to work.
 
function onEnable()
	adminsOnly	= config:getProperty("adminsOnly")
	dbInit()							-- init DB, if required
	print(msg_init)
end

-- onDisable()
--
-- called at script unloading

function onDisable()
	print(msg_deinit)
end

--------------------
-- U T I L I T Y  F U N C T I O N S
--------------------

-- toInteger(val)
--
-- returns val as an integer number if it can be interpreted as one or nil if it cannot.
 
function toInteger(val)
	if val == nil or tonumber(val) == nil then
		return nil
	end
	val = tonumber(val)
	if math.floor(val) == val then
		return val
	else
		return nil
	end
end
