-- T E L e v a t o r 
-- Implements elevators via teleporting
--
-- messages.lua: textual messages, separated for easier translation
--
-- (C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
-- Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

-- Error messages
err_createSynt			= "Use [#00ff40]/elev create <name>[#ffffff] to create a new, empty elevator."
err_createLevelSynt		= "Use [#00ff40]/elev createlevel <elev Id> <level ordinal>[#ffffff] to create a new elevator level."
err_deleteSynt			= "Use [#00ff40]/elev deletelevel <elev Id>[#ffffff] to delete an elevator."
err_deleteLevelSynt		= "Use [#00ff40]/elev deletelevel <elev Id> <level ordinal>[#ffffff] to delete a level."
err_elevDoesntExist		= "[#a00000]Elevator %d does not exists."
err_floorAlreadyAtFloor	= "[#a00000]Your are already at floor %d"
err_floorDoesntExists	= "[#a00000]Floor %d does not exist in this elevator"
err_floorNotInElevator	= "[#a00000]You are not within an elevator"
err_floorSynt			= "Use [#0040]/floor <level_num>[#ffffff] to jump to an elevator level."
err_levelAlreadyExists	= "[#a00000]Elevator %d already has level %d."
err_notAdmin			= "[#ff0000]You are not an admin"

-- Info messages
msg_init				= "TELevator loaded successfully! (version "..scriptVersion..")"
msg_deinit				= "TELevator script unloaded."
msg_createDone			= "Elevator '%s' created with ID %d."
msg_createLevelDone		= "Level created."
msg_deleteDone			= "Elevator %d deleted with all its levels."
msg_deleteLevelDone		= "Level %d deleted from elevator %d."
msg_invalidElevCommand	= "Unknown /elev command"
msg_selectAborted		= "Area selection stopped."
msg_selectArea			= "Select the area, stand on the platform and use \"/elev createlevel\" to save it."

-- Various texts
txt_Elevator	= "Elevator"
txt_Level		= "Level"
txt_help		= { "[#00ff40]TELevator help",
			"[#00ff40]/elev new <name> [#ffffff]creates a new, empty elevator",
			"[#00ff40]/elev selectlevel [#ffffff]selects the area that will become a level",
			"[#00ff40]/elev newlevel <elev.ID> <level ordinal> [#ffffff]creates the level for given elevator",
			"[#00ff40]/elev delete <elev.ID> [#ffffff]deletes the elevator and all its levels",
			"[#00ff40]/elev deletelevel <elev.ID> <level ordinal> [#ffffff]deletes the level for given elevator",
			"[#00ff40]/elev list [#ffffff]lists the elevators",
			"[#00ff40]/elev show [#ffffff]visually shows the elevators",
			"[#00ff40]/elev hide [#ffffff]hides elevators",
		}
