-- T E L e v a t o r 
-- Implements elevators via teleporting
--
-- database.lua: database and in-memory run-time cache management
--
-- (C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
-- Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

--
-- dbInit()
--
-- Initialises the DB if not present and load existing data into in-memory cache.
-- Can be run at each script startup without destroying existing data

function dbInit()
	-- create tables if not existing already
	database:queryupdate("CREATE TABLE IF NOT EXISTS 'elevators'( \
		'ID' INTEGER PRIMARY KEY, \
		'name' VARCHAR);"
	)

	database:queryupdate("CREATE TABLE IF NOT EXISTS `levels`( \
		`elevId`   INTEGER, \
		`level`    INTEGER, \
		`chunkXfr` INTEGER, \
		`chunkYfr` INTEGER, \
		`chunkZfr` INTEGER, \
		`blockXfr` INTEGER, \
		`blockYfr` INTEGER, \
		`blockZfr` INTEGER, \
		`chunkXto` INTEGER, \
		`chunkYto` INTEGER, \
		`chunkZto` INTEGER, \
		`blockXto` INTEGER, \
		`blockYto` INTEGER, \
		`blockZto` INTEGER, \
		`landH`    INTEGER, \
		PRIMARY KEY (elevId, level) );"
	)
	dbLoad()
end

--
-- dbLoad()
--
-- Loads the DB into in-memory cache

function dbLoad()
	-- load elevators
	elevators = {}			-- clear elevators table
	local result = database:query("SELECT * FROM elevators ORDER BY ID;")
	while result:next() do
		elevators[result:getInt("ID")] = result:getString("name")
	end

	-- load levels
	levels = {}				-- clear levels table
	result = database:query("SELECT * FROM levels ORDER BY elevId, level;")
	while result:next() do
		local levl			= {}
		levl["ID"]			= result:getInt("ID")
		levl["elevId"]		= result:getInt("elevId")
		levl["level"]		= result:getInt("level")
		levl["chunkXfr"]	= result:getInt("chunkXfr")
		levl["chunkYfr"]	= result:getInt("chunkYfr")
		levl["chunkZfr"]	= result:getInt("chunkZfr")
		levl["blockXfr"]	= result:getInt("blockXfr")
		levl["blockYfr"]	= result:getInt("blockYfr")
		levl["blockZfr"]	= result:getInt("blockZfr")
		levl["chunkXto"]	= result:getInt("chunkXto")
		levl["chunkYto"]	= result:getInt("chunkYto")
		levl["chunkZto"]	= result:getInt("chunkZto")
		levl["blockXto"]	= result:getInt("blockXto")
		levl["blockYto"]	= result:getInt("blockYto")
		levl["blockZto"]	= result:getInt("blockZto")
		levl["landH"]		= result:getFloat("landH")		-- the altitude to land the player at
		getGlobalPos(levl)
		levels[levl.ID] = levl;
	end
end

--
-- dbNewElevator(name)
--
-- Insert into the DB and into the in-memory cache a new elevator with name `name and return its Id

function dbNewElevator(name)
	database:queryupdate("INSERT INTO elevators (name) VALUES ('"..name.."')")
	local lastInsertId	= database:getLastInsertID()
	elevators[lastInsertId]	= name
	return lastInsertId
end

--
-- dbNewLevel(level)
--
-- Insert into the DB and into the in-memory cache a new elevator level

function dbNewLevel(level)
	database:queryupdate("INSERT INTO levels(elevId, level, chunkXfr, chunkYfr, chunkZfr, blockXfr, blockYfr, blockZfr, \
			chunkXto, chunkYto, chunkZto, blockXto, blockYto, blockZto, landH) VALUES \
			("..level.elevId..","..level.level..","..
			level.chunkXfr..","..level.chunkYfr..","..level.chunkZfr..","..
			level.blockXfr..","..level.blockYfr..","..level.blockZfr..","..
			level.chunkXto..","..level.chunkYto..","..level.chunkZto..","..
			level.blockXto..","..level.blockYto..","..level.blockZto..","..level.landH..")")
	local insertID = database:getLastInsertID()
	level["ID"] = insertID
	levels[insertID] = level
	return lastInsertId
end

--
-- dbDelete(elevId)
--
-- Deletes the elevId-th elevator.

function dbDeleteElevator(player, elevId)
	database:queryupdate("DELETE FROM levels WHERE elevId = " .. elevId)
	database:queryupdate("DELETE FROM elevators WHERE ID = " .. elevId)
	dbLoad()
end

--
-- dbDeleteLevel(elevId, levelOrd)
--
-- Deletes the levelOrd-th level of elevator elevId.

function dbDeleteLevel(elevId, levelOrd)
	local levelId
	for k,v in pairs(levels) do
		if v.elevId == elevId and v.level == levelOrd then
			levelId = k
			table.remove(levels, k)
			break
		end
	end
	database:queryupdate("DELETE FROM levels WHERE elevId = " .. elevId .. " and level == " .. levelOrd)
end
