-- T E L e v a t o r 
-- Implements elevators via teleporting
--
-- commands.lua: implements commands available to players and admins
--
-- (C) Maurizio M. Gavioli (a.k.a. Miwarre), 2016
-- Licensed under the Creative Commons by-sa 3.0 license (see http://creativecommons.org/licenses/by-sa/3.0/ for details)

--
-- onPlayerQuickSlotChange
--
-- called by the framework when the player changes the quick slot

-- THIS DOES NOT SEEM TO WORK !!
--[[
function onPlayerQuickSlotChange(event)
event.player:sendTextMessage("Entering quick slot change to: "..event.newFocus)
	-- attempt transporting to floor
	local retval = toElevatorLevel(event.player, event.newFocus)
event.player:sendTextMessage("Slot change to "..event.newFocus..": "..retVal)
	-- if syntax error (well, should not happen!) or not in an elevator, ignore
	if retVal == -1 or retVal == -2 then
		return
	elseif retVal == -3 then
		eent.player:sendTextMessage(err_floorNotInElevator)
	elseif retVal == -4 then
		event.player:sendTextMessage(string.format(err_floorAlreadyAtFloor, event.newFocus) )
	end
	event.setCancel(true)			-- intercept quickslot change
end
addEvent("PlayerQuickslotChange", onPlayerQuickSlotChange);
]]
-- onPlayerCommand
--
-- called when the player issues a command ("/...") in the chat window

function onPlayerCommand(event)
	local player	= event.player
	local cmd		= StringUtils:explode(event.command, " ")

	if cmd[1] == "/floor" then
		local retVal = toElevatorLevel(player, cmd[2])
		if retVal == -1 then
			player:sendTextMessage(err_floorSynt)
		elseif retVal == -2 then
			player:sendTextMessage(string.format(err_floorDoesntExists, cmd[2]) )
		elseif retVal == -3 then
			player:sendTextMessage(err_floorNotInElevator)
		elseif retVal == -4 then
			player:sendTextMessage(string.format(err_floorAlreadyAtFloor, cmd[2]) )
		end
		return
	end

	-- All following commands are only usable when enabled or the player is an admin!
	if cmd[1] == "/elev" then
		if player:isAdmin() == false and adminsOnly then
			player:sendTextMessage(err_notAdmin)
			return
		end

		if cmd[2] == "new" then						-- sub-command "new" creates a new, empty, elevator
			if cmd[3] == nil then
				player:sendTextMessage(err_createSynt)
				return
			end
			local elevId = dbNewElevator(cmd[3])
			player:sendTextMessage(string.format(msg_createDone, cmd[3], elevId) )

		elseif cmd[2] == "selectlevel" then			-- sub-command "selectlevel" selects the area that will be used as a level
			player:enableMarkingSelector(function() end)	-- callback required; empty one provided
			player:sendYellMessage(msg_selectArea)

		elseif cmd[2] == "abortselect" then			-- sub-command "abortselect" stops an ongoing selectiion process
			player:disableMarkingSelector(function() end)	-- callback required; empty one provided
			player:sendTextMessage(msg_selectAborted)

		elseif cmd[2] == "newlevel" then			-- sub-command "createlevel" creates a new level
			newLevel(player, cmd[3], cmd[4])

		elseif cmd[2] == "show" then				-- sub-command "show" visualises all existing elevator levels
			local locLevels = {}
			for key,value in pairs(levels) do
				local level	= {}
				level[1]	= value["ID"]
				level[2]	= value["chunkXfr"]
				level[3]	= value["chunkYfr"]
				level[4]	= value["chunkZfr"]
				level[5]	= value["blockXfr"]
				level[6]	= value["blockYfr"]
				level[7]	= value["blockZfr"]
				level[8]	= value["chunkXto"]
				level[9]	= value["chunkYto"]
				level[10]	= value["chunkZto"]
				level[11]	= value["blockXto"]
				level[12]	= value["blockYto"]
				level[13]	= value["blockZto"]
				level[14]	= 0xFFFF0000
				table.insert(locLevels, level)
			end
			event.player:setAttribute(key_elevatorsShown, true)
			event.player:createAreas(locLevels)
			event.player:showAllAreas()

		elseif cmd[2] == "hide" then				-- sub-command "hide" hides elevators
			local levelIds = {}
			if levels == nil then
				return
			end
			for key,value in pairs(levels) do
				table.insert(levelIds, value["ID"])
			end
			player:hideAreas(levelIds)
			player:setAttribute(key_elevatorsShown, false)

		elseif cmd[2] == "help" then				-- sub-command "help"
			help(player)
			return

		elseif cmd[2] == "list" then				-- sub-command "list" lists the elevators
			for k,v in pairs(elevators) do
				player:sendTextMessage(txt_Elevator.." "..k.. " '"..v.."'")
				for l,w in pairs(levels) do
					if w.elevId == k then
						player:sendTextMessage("  "..txt_Level.." ".. w.level..
								": "..w.globlZfr.."-"..w.globlZto.."N, "..w.globlXfr.."-"..w.globlXto.."W, "
								..w.globlYfr.."-"..w.globlYto.."h")
					end
				end
			end

		elseif cmd[2] == "delete" then
			local elevId	= toInteger(cmd[3])
			if elevId == nil then
				player:sendTextMessage(err_deleteSynt)
				return
			end
			if elevators[elevId] == nil then
				player:sendTextMessage(string.format(err_elevDoesntExist, elevId) )
				return
			end
			dbDeleteElevator(player, elevId)
			player:sendTextMessage(string.format(msg_deleteDone, elevId) )

		elseif cmd[2] == "deletelevel" then
			local elevId	= toInteger(cmd[3])
			local levelOrd	= toInteger(cmd[4])
			if elevId == nil or levelOrd == nil then
				player:sendTextMessage(err_deleteLevelSynt)
				return
			end
			if elevators[elevId] == nil then
				player:sendTextMessage(string.format(err_elevDoesntExist, elevId) )
				return
			end
			if getLevelAtLevel(elevId, levelOrd) == nil then
				player:sendtextMessage(string.format(err_floorDoesntExists, levelOrd) )
				return
			end
			dbDeleteLevel(elevId, levelOrd)
			player:sendTextMessage(string.format(msg_deleteLevelDone, levelOrd, elevId) )

		else
			player:sendTextMessage(msg_invalidElevCommand)

		end				-- end of elseif chain
	end					-- end of if cmd[1] == "/elev"
end						-- end of function
addEvent("PlayerCommand", onPlayerCommand);

--
-- newLevel(player, elevId, levelOrd)
--
-- Creates a new levelOrd-th level for elevator elevId

function newLevel(player, elevId, levelOrd)
	-- check elevator id and level ordinal are provided and are numbers
	if elevId == nil or tonumber(elevId) == nil or levelOrd == nil or tonumber(levelOrd) == nil then
		player:sendTextMessage(err_createLevelSynt)
		return
	end
	elevId	= tonumber(elevId)
	levelOrd	= tonumber(levelOrd)
	-- check elevator id and level ordinal are integers
	if math.floor(elevId) ~= elevId or math.floor(levelOrd) ~= levelOrd then
		player:sendTextMessage(err_createLevelSynt)
		return
	end
	-- check elevator exists
	if getElevator(elevId) == nil then
		player:sendTextMessage(string.format(err_elevDoesntExist, elevId) )
		return
	end
	-- check elevator does not already contain this level
	if getLevelAtLevel(elevId, levelOrd) ~= nil then
		player:sendTextMessage(string.format(err_levelAlreadyExists, elevId, levelId) )
		return
	end
	-- end marking stage
	player:disableMarkingSelector(	-- provide a callback function
		function(markEvt)
			if markEvt == false then
				return
			end
			-- collect level data and insert it into the DB
			local level = {}
			level["elevId"]		= elevId
			level["level"]		= levelOrd
			level["chunkXfr"]	= markEvt.startChunkpositionX
			level["chunkYfr"]	= markEvt.startChunkpositionY
			level["chunkZfr"]	= markEvt.startChunkpositionZ
			level["blockXfr"]	= markEvt.startBlockpositionX
			level["blockYfr"]	= markEvt.startBlockpositionY
			level["blockZfr"]	= markEvt.startBlockpositionZ
			level["chunkXto"]	= markEvt.endChunkpositionX
			level["chunkYto"]	= markEvt.endChunkpositionY
			level["chunkZto"]	= markEvt.endChunkpositionZ
			level["blockXto"]	= markEvt.endBlockpositionX
			level["blockYto"]	= markEvt.endBlockpositionY
			level["blockZto"]	= markEvt.endBlockpositionZ
			level["landH"]		= player:getPosition().y
			normaliseBoundaries(level)
			getGlobalPos(level)
			dbNewLevel(level)
			-- if elevators are shown, add a new area to shown areas
			if player:getAttribute(key_elevatorsShown) == true then
				player:createArea(insertID, level.chunkXfr, level.chunkYfr, level.chunkZfr,
						level.blockXfr, level.blockYfr, level.blockZfr, level.chunkXto, level.chunkYto, level.chunkZfr,
						level.blockXto, level.blockYto, level.blockZto, 0x0000ff00)
				player:showArea(insertID)
			end
			player:sendTextMessage(msg_createLevelDone);
		end
	);
end

-- help()
--
-- Displays help summary

function help(player)
	for k,v in pairs(txt_help) do
		player:sendTextMessage(v)
	end
end
