-- Whitelist extension for Rising World
-- Copyright and all this shit: username

whitelist = {};
database = getDatabase()
server = getServer()


function onPlayerCommand(event)
	-- Split the command string
	local cmd = StringUtils:explode(event.command, " ");
	cmd[1] = string.lower(cmd[1]);
	
	if #cmd >= 2 and cmd[1] == "/whitelist" then
		-- working with whitelist requires admin permission!
		if not event.player:isAdmin() then return event.player:sendTextMessage("Permission denied!") end
		
		
		-- Command 'add' to add a player to the whitelist
		if cmd[2] == "add" then
			if not cmd[3] then return msgInvalidUsage(event.player) end
			
			whitelist[cmd[3]] = event.player:getPlayerName()
			local query = "INSERT INTO whitelist (player, by) VALUES ('" .. cmd[3] .. "','" .. event.player:getPlayerName() .. "');"
			database:queryupdate(query);
			print("Added " .. cmd[3] .." to whitelist");
			event.player:sendTextMessage("whitelisted " .. cmd[3])
		
		
		-- Command 'del' to remove a player from the whitelist
		elseif cmd[2] == "del" then
			if not cmd[3] then return msgInvalidUsage(event.player) end
			if not whitelist[cmd[3]] then return event.player:sendTextMessage("Player " .. cmd[3] .. " not found in whitelist.") end
			
			local query = "DELETE FROM whitelist WHERE player= '" .. cmd[3] .. "'"
			database:queryupdate(query);
			whitelist[cmd[3]] = nil
			print("Removed " .. cmd[3] .. " from whitelist");
			event.player:sendTextMessage("Removed " .. cmd[3] .. " from whitelist")
			
		
		-- Command 'list' to list all whitelisted players and the admin who added them
		elseif cmd[2] == "list" then
			print("Listing whitelist");
			for key,value in pairs(whitelist) do
				event.player:sendTextMessage("Player:" .. key .. "  -  Added by: " .. value)
			end
		
		
		--Helptext
		elseif cmd[2] == "help" then
			event.player:sendTextMessage("/whitelist add player    - add a player to the whitelist")
			event.player:sendTextMessage("/whitelist del player    - remove a player to the whitelist")
			event.player:sendTextMessage("/whitelist list          - show entire whitelist")
		
		end
	end
end
addEvent("PlayerCommand", onPlayerCommand);


-- kicking player on connect if not whitelisted
function onPlayerConnect(event)
	-- ignoring admins from whitelistcheck
	if event.player:isAdmin() then return true end
	
	-- kick if not whitelisted
	if not whitelist[event.player:getPlayerName()] then
		event.player:kick("Not whitelisted!")
		print("Kicking not whitelisted player: " .. event.player:getPlayerName());
	end
end
addEvent("PlayerConnect", onPlayerConnect);


function msgInvalidUsage(player)
    player:sendTextMessage("Usage: /whitelist <add|del|list|help> [playername]")
end


function onEnable()
    database:queryupdate("CREATE TABLE IF NOT EXISTS `whitelist` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `player` VARCHAR, `by` VARCHAR)");
    
    local result = database:query("SELECT * FROM whitelist;");
	while result:next() do
		whitelist[result:getString("player")] = result:getString("by");
	end
	
    print("Whitelist loaded");
end
