
--- Player command event.
-- This event is triggered the the player sends a command.
-- A command is defined as input into the chat beginning with "/".
-- Commands are not shown in global chat, but triggers this event.
-- @param event The event object
-- @usage The whole command string is stored in the event object (event.command) 
-- as well as the player (event.player).
function onPlayerCommand(event)

--	if event.player:getPlayerGroup() == "Surveyor" then
--		-- If the player is a surveyor stop processing the script
--		return;
--	end
-- moved to teleporting only areas infact this is not needed because you need fly mode on witch level 1 uaers cant do

	-- Split the command string
	local cmd = StringUtils:explode(event.command, " ");
	
	if #cmd >= 1 then
		cmd[1] = string.lower(cmd[1]);
		
		-- Command /showareas to visualize all existing areas
		if cmd[1] == "/showareas" then
			local world = getWorld();
			local playerAreas = {};
			for key,value in pairs(areas) do
				local area = {};
				area[1] = value["areaID"];
				area[2] = value["startChunkpositionX"];
				area[3] = value["startChunkpositionY"];
				area[4] = value["startChunkpositionZ"];
				area[5] = value["startBlockpositionX"];
				area[6] = value["startBlockpositionY"];
				area[7] = value["startBlockpositionZ"];
				area[8] = value["endChunkpositionX"];
				area[9] = value["endChunkpositionY"];
				area[10] = value["endChunkpositionZ"];
				area[11] = value["endBlockpositionX"];
				area[12] = value["endBlockpositionY"];
				area[13] = value["endBlockpositionZ"];
				area[14] = colors[math.random(#colors)];
				table.insert(playerAreas, area);
			end
			event.player:setAttribute("areasVisible", true);
			event.player:createAreas(playerAreas);
			event.player:showAllAreas();
			
		-- Command /hideareas to hide all visualized areas
		elseif cmd[1] == "/hideareas" then
			local areaIds = {};
			for key,value in pairs(areas) do
				table.insert(areaIds, value["areaID"]);
			end
			event.player:destroyAreas(areaIds);
			event.player:setAttribute("areasVisible", false);

		-- Command /arealist lists all the areas defined
		elseif cmd[1] == "/arealist" then
			local result = database:query("SELECT * FROM areas;");
			if result:isAfterLast() then
				event.player:sendTextMessage("[#00FF00]There are no areas defined!");
			else
				event.player:sendTextMessage("[#00FF00]Area list, use Name for /areatp2, use ID for /areatp");
				while result:next() do
					event.player:sendTextMessage("[#00FF00]ID = " .. result:getInt("ID") .. ", Name = " .. result:getString("name"));
				end
			end
			
		-- Command /areatp2 will teleport you to the given area by name, make sure that you are flying when you use this!!!
		elseif cmd[1] == "/areatp2" then
			if #cmd >= 2 then
				if event.player:isFlying() == false then
					event.player:sendTextMessage("[#00FF00]Make sure that you are flying before you use teleport to area!");
				else
					local result = database:query("SELECT * FROM areas where name = \"".. string.sub(event.command, 9) .. "\";");
					if result:isAfterLast() then
						event.player:sendTextMessage("[#00FF00]Area \"" .. string.sub(event.command, 9) .. "\" does not exist!");
					else
						local tempSX = ChunkUtils:getGlobalBlockPositionX(result:getInt("startChunkpositionX"), result:getInt("startBlockpositionX"));
						local tempSY = ChunkUtils:getGlobalBlockPositionY(result:getInt("startChunkpositionY"), result:getInt("startBlockpositionY"));
						local tempSZ = ChunkUtils:getGlobalBlockPositionZ(result:getInt("startChunkpositionZ"), result:getInt("startBlockpositionZ"));
						local tempEX = ChunkUtils:getGlobalBlockPositionX(result:getInt("endChunkpositionX"), result:getInt("endBlockpositionX"));
						local tempEY = ChunkUtils:getGlobalBlockPositionY(result:getInt("endChunkpositionY"), result:getInt("endBlockpositionY"));
						local tempEZ = ChunkUtils:getGlobalBlockPositionZ(result:getInt("endChunkpositionZ"), result:getInt("endBlockpositionZ"));
						
						local tpX = (tempEX - ((tempEX - tempSX) / 2));
						local tpY = (tempEY - ((tempEY - tempSY) / 2));
						local tpZ = (tempEZ - ((tempEZ - tempSZ) / 2));
						event.player:setPosition(tpX, tpY, tpZ);
					end
				end
			else
				event.player:sendTextMessage("[#FF0000]Use /areatp2 areaName (areaName is the name of the area, you can find this in /arealist)");
			end

		-- Command /areatp will teleport you to the given area by ID, make sure that you are flying when you use this!!!
		elseif cmd[1] == "/areatp" then
			if #cmd >= 2 then
				if event.player:isFlying() == false then
					event.player:sendTextMessage("[#00FF00]Make sure that you are flying before you use teleport to area!");
				elseif event.player:getPlayerGroup() == "Surveyor" then
		              -- If the player is a surveyor stop processing the script
		            return;
				
	            else
					local result = database:query("SELECT * FROM areas where ID = \"".. cmd[2] .. "\";");
					if result:isAfterLast() then
						event.player:sendTextMessage("[#00FF00]Area \"" .. string.sub(event.command, 9) .. "\" does not exist!");
					else
						local tempSX = ChunkUtils:getGlobalBlockPositionX(result:getInt("startChunkpositionX"), result:getInt("startBlockpositionX"));
						local tempSY = ChunkUtils:getGlobalBlockPositionY(result:getInt("startChunkpositionY"), result:getInt("startBlockpositionY"));
						local tempSZ = ChunkUtils:getGlobalBlockPositionZ(result:getInt("startChunkpositionZ"), result:getInt("startBlockpositionZ"));
						local tempEX = ChunkUtils:getGlobalBlockPositionX(result:getInt("endChunkpositionX"), result:getInt("endBlockpositionX"));
						local tempEY = ChunkUtils:getGlobalBlockPositionY(result:getInt("endChunkpositionY"), result:getInt("endBlockpositionY"));
						local tempEZ = ChunkUtils:getGlobalBlockPositionZ(result:getInt("endChunkpositionZ"), result:getInt("endBlockpositionZ"));
						
						local tpX = (tempEX - ((tempEX - tempSX) / 2));
						local tpY = (tempEY - ((tempEY - tempSY) / 2));
						local tpZ = (tempEZ - ((tempEZ - tempSZ) / 2));
						event.player:setPosition(tpX, tpY, tpZ);
					end
				end
			else
				event.player:sendTextMessage("[#FF0000]Use /areatp areaID (areaID is the ID of the area, you can find this in /arealist)");
			end

		-- Command /showareainfo to show all members of an area with their groups
		elseif cmd[1] == "/showareainfo" then
			if #cmd == 1 then
				local areaID = event.player:getAttribute("areaID");
				if areaID ~= nil then
					if #cmd == 1 then
						local result = database:query("SELECT * FROM rights where areaID = ".. areaID .. ";");
						if result:isAfterLast() then
							event.player:sendTextMessage("[#00FF00]No players added to this area yet!");
						else
							while result:next() do
								local player = server:getPlayerInformationFromDB(result:getInt("playerID"));
								event.player:sendTextMessage("[#00FF00]Player \"" .. player.name .. "\" is member of group ".. result:getString("group") .."!");
							end
						end
					end
				else
					event.player:sendTextMessage("[#FF0000]You must enter an area first or specify an area name!");
				end
			elseif #cmd >= 2 then
				local result = database:query("SELECT * FROM areas where name = \"".. string.sub(event.command, 15) .. "\";");
				while result:next() do
					local areaID = result:getInt("ID");
					if areaID ~= "" then
						local result = database:query("SELECT * FROM rights where areaID = ".. areaID .. ";");
						if result:isAfterLast() then
							event.player:sendTextMessage("[#00FF00]No players added to area \"" .. string.sub(event.command, 15) .. "\" yet!");
						else
							while result:next() do
								local player = server:getPlayerInformationFromDB(result:getInt("playerID"));
								event.player:sendTextMessage("[#00FF00]Players added to area " .. string.sub(event.command, 15));
								event.player:sendTextMessage("[#00FF00]Player \"" .. player.name .. "\" is member of group ".. result:getString("group") .."!");
							end
						end
					end
				end	
			end
		end
		
		-- Command /addplayertoarea to add a player to the provided group inside the area you currently are
		if cmd[1] == "/addplayertoarea" then
			local areaID = event.player:getAttribute("areaID");
			if areaID ~= nil then
				local group = event.player:getAttribute("areaGroup");
				if group["CanAddPlayer"] == true or event.player:isAdmin() then
					if #cmd >= 3 then
						if cmd[2] ~= "Friend" and event.player:isAdmin() == false then
							event.player:sendTextMessage("[#FF0000]You must use \"/addplayertoarea Friend [UserName]\"!");
						elseif cmd[3] == event.player:getName() and event.player:isAdmin() == false then
							event.player:sendTextMessage("[#FF0000]You can not change your own group!");
						else
							local group = getGroupByName(cmd[2]);
							local player = server:getPlayerInformationFromDB(cmd[3]);
							if group ~= nil then
								if player ~= nil then
									if areas[areaID]["rights"][player.dbID] == nil then
										database:queryupdate("INSERT INTO rights ('areaID', 'playerID', 'group') VALUES ('".. areas[areaID]["areaID"] .."', '".. player.dbID .. "', '".. cmd[2] .. "')");
									else
										database:queryupdate ("UPDATE rights SET 'group'='".. cmd[2] .."' WHERE playerID= '" .. player.dbID .. "' AND areaID='" .. areaID .. "'");
									end
									areas[areaID]["rights"][player.dbID] = group;
										
									event.player:sendTextMessage("[#00FF00]Player \"" .. cmd[3] .. "\" successfully added to area (".. cmd[2] ..")!");
								else
									event.player:sendTextMessage("[#FF0000]Player \"" .. cmd[3] .. "\" not found!");
								end
							else
								event.player:sendTextMessage("[#FF0000]Group \"" .. cmd[2] .. "\" not found!");
							end
						end
					else
						event.player:sendTextMessage("[#FF0000]Use /addplayertoarea [GroupName] [PlayerName]");
					end
				else
					event.player:sendTextMessage("[#FF0000]You do not have the rights to add or remove players from this area!");
				end
			else
				event.player:sendTextMessage("[#FF0000]You must enter an area first!");
			end
					
		-- Command /removeplayerfromarea to unregister a player from the area you're standing in
		elseif cmd[1] == "/removeplayerfromarea" then
			local areaID = event.player:getAttribute("areaID");
			if areaID ~= nil then
				local group = event.player:getAttribute("areaGroup");
				if group["CanAddPlayer"] == true or event.player:isAdmin() then
					if #cmd >= 2 then
						local player = server:getPlayerInformationFromDB(cmd[2]);
						if player ~= nil then
							areas[areaID]["rights"][player.dbID] = nil;
							database:queryupdate("DELETE FROM rights WHERE playerID= '" .. player.dbID .. "' AND areaID='" .. areaID .. "'");
							event.player:sendTextMessage("[#00FF00]Player \"" .. cmd[2] .. "\" successfully removed from area!");
						else
							event.player:sendTextMessage("[#FF0000]Player \"" .. cmd[2] .. "\" not found!");
						end
					else
						event.player:sendTextMessage("[#FF0000]Use /removeplayerfromarea [PlayerName]");
					end
				else
					event.player:sendTextMessage("[#FF0000]You do not have the rights to add or remove players from this area!");
				end
			else
				event.player:sendTextMessage("[#FF0000]You must enter an area first!");
			end
		end
		
		-- All following commands are only usable when the player is an admin!
		if event.player:isAdmin() == false then
			--event.player:sendTextMessage("[#FF0000]You are not an admin");
			return;
		end
		
		-- Command /selectarea to visualize all existing areas
		if cmd[1] == "/selectarea" then
			-- This is a Callback function, so we have to provide a function as parameter
			-- which is called when the callback is done
			event.player:enableMarkingSelector(function() end);
			
			event.player:sendYellMessage("Select the area and type \"/createarea\" to save it");

	
		-- Command /createarea to save the area you have defined previously
		elseif cmd[1] == "/createarea" then
			if #cmd >= 2 then
				-- Provide a Callback-function, since it can't be triggered immediately, only after we receive the response from the player
				event.player:disableMarkingSelector(function(markingEvent)
					if markingEvent ~= false then
						local area = {};
						area["playerID"] = markingEvent.player:getDBID();
						area["areaName"] = string.sub(event.command, 13);
						area["startChunkpositionX"] = markingEvent.startChunkpositionX;
						area["startChunkpositionY"] = markingEvent.startChunkpositionY;
						area["startChunkpositionZ"] = markingEvent.startChunkpositionZ;
						area["startBlockpositionX"] = markingEvent.startBlockpositionX;
						area["startBlockpositionY"] = markingEvent.startBlockpositionY;
						area["startBlockpositionZ"] = markingEvent.startBlockpositionZ;
						
						area["endChunkpositionX"] = markingEvent.endChunkpositionX;
						area["endChunkpositionY"] = markingEvent.endChunkpositionY;
						area["endChunkpositionZ"] = markingEvent.endChunkpositionZ;
						area["endBlockpositionX"] = markingEvent.endBlockpositionX;
						area["endBlockpositionY"] = markingEvent.endBlockpositionY;
						area["endBlockpositionZ"] = markingEvent.endBlockpositionZ;
						area["rights"] = {};
						
						adjustAreaPositions(area);
						calculateGlobalAreaPosition(area);
						
						database:queryupdate("INSERT INTO areas(name, startChunkpositionX, startChunkpositionY, startChunkpositionZ, startBlockpositionX, startBlockpositionY, startBlockpositionZ, endChunkpositionX, endChunkpositionY, endChunkpositionZ, endBlockpositionX, endBlockpositionY, endBlockpositionZ, playerID) VALUES ('".. string.sub(event.command, 13) .."', '".. area["startChunkpositionX"] .."', '".. area["startChunkpositionY"] .."', '".. area["startChunkpositionZ"] .."', '".. area["startBlockpositionX"] .."', '".. area["startBlockpositionY"] .."', '".. area["startBlockpositionZ"] .."', '".. area["endChunkpositionX"] .."', '".. area["endChunkpositionY"] .."', '".. area["endChunkpositionZ"] .."', '".. area["endBlockpositionX"] .."', '".. area["endBlockpositionY"] .."', '".. area["endBlockpositionZ"] .."', '".. markingEvent.player:getDBID() .."')");
						local insertID = database:getLastInsertID();
						area["areaID"] = insertID;
						areas[insertID] = area;
						
						if event.player:getAttribute("areasVisible") == true then
							event.player:createArea(insertID, area["startChunkpositionX"], area["startChunkpositionY"], area["startChunkpositionZ"], area["startBlockpositionX"], area["startBlockpositionY"], area["startBlockpositionZ"], area["endChunkpositionX"], area["endChunkpositionY"], area["endChunkpositionZ"], area["endBlockpositionX"], area["endBlockpositionY"], area["endBlockpositionZ"], colors[math.random(#colors)]);
							event.player:showArea(insertID);
						end
						event.player:sendTextMessage("[#00FF00]Area successfully created!");
					end
				end);
			else
				event.player:sendTextMessage("[#FF0000]Use /createarea [AreaName]");
			end
			
		--Command /removearea to delete the area you're currently inside
		elseif cmd[1] == "/removearea" then
			local areaID = event.player:getAttribute("areaID");
			if areaID ~= nil then
				database:queryupdate("DELETE FROM areas WHERE ID= '" .. areas[areaID]["areaID"] .. "'");
				database:queryupdate("DELETE FROM rights WHERE areaID= '" .. areas[areaID]["areaID"] .. "'");
				areas[areaID] = nil;
				event.player:setAttribute("areaID", nil);
				event.player:setAttribute("areaGroup", nil);
				event.player:destroyArea(areaID);
				event.player:sendTextMessage("[#00FF00]Area successfully removed!");
				if event.player:getAttribute("areasVisible") == true then
					event.player:destroyArea(areaID);
				end
			else
				event.player:sendTextMessage("[#FF0000]You must enter an area first!");
			end
			
			
		-- Command /reloadgroups to reload all group propertyfiles
		elseif cmd[1] == "/reloadgroups" then
			loadGroups();
			

		-- Command /showareaplayerrights to show all members of an area with their rights
		elseif cmd[1] == "/showareaplayerrights" then
			if #cmd >= 1 then
				local areaID = event.player:getAttribute("areaID");
				if areaID ~= nil then
					if #cmd == 1 then
						local result = database:query("SELECT * FROM rights where areaID = ".. areaID .. ";");
						while result:next() do
							local player = server:getPlayerInformationFromDB(result:getInt("playerID"));
							event.player:sendTextMessage("[#00FF00]Player \"" .. player.name .. "\" is member of group ".. result:getString("group") .."!");
						end
					else
						local player = server:getPlayerInformationFromDB(cmd[2]);
						local result = database:query("SELECT * FROM rights where areaID = ".. areaID .. " and playerID = ".. player.dbID ..";");
						while result:next() do
							event.player:sendTextMessage("[#00FF00]Player \"" .. player.name .. "\" is member of group ".. result:getString("group") .."!");
						end
					end
				else
					event.player:sendTextMessage("[#FF0000]You must enter an area first!");
				end
			else
				event.player:sendTextMessage("[#FF0000]Use /showareaplayerrights [PlayerName] (Playername is optional)");
			end
			
		-- Command /cleanuparea to remove all objects, constructions, vegetations and blocks from an area
		elseif cmd[1] == "/cleanuparea" then
			local area = nil;
			
			-- Find the area, if the player provided the area name, you can search for the particular area...
			if #cmd >= 2 then
				for key,value in pairs(areas) do
					if value["areaName"] == cmd[2] then
						area = value;
						break;
					end
				end
			-- ...otherwise we check if the player is currently inside an area
			else
				local areaID = event.player:getAttribute("areaID");
				if areaID ~= nil then
					area = areas[areaID];
				end
			end
			
			if area ~= nil then
				print("Cleanup area "..area["areaName"]);
				-- Removes all objects inside the area
				world:removeAllObjectsInArea(area["startChunkpositionX"], area["startChunkpositionY"], area["startChunkpositionZ"], area["startBlockpositionX"], area["startBlockpositionY"], area["startBlockpositionZ"], area["endChunkpositionX"], area["endChunkpositionY"], area["endChunkpositionZ"], area["endBlockpositionX"], area["endBlockpositionY"], area["endBlockpositionZ"]);
				-- Removes all constructions inside the area
				world:removeAllConstructionsInArea(area["startChunkpositionX"], area["startChunkpositionY"], area["startChunkpositionZ"], area["startBlockpositionX"], area["startBlockpositionY"], area["startBlockpositionZ"], area["endChunkpositionX"], area["endChunkpositionY"], area["endChunkpositionZ"], area["endBlockpositionX"], area["endBlockpositionY"], area["endBlockpositionZ"]);
				-- Removes all vegetations inside the area
				world:removeAllVegetationsInArea(area["startChunkpositionX"], area["startChunkpositionY"], area["startChunkpositionZ"], area["startBlockpositionX"], area["startBlockpositionY"], area["startBlockpositionZ"], area["endChunkpositionX"], area["endChunkpositionY"], area["endChunkpositionZ"], area["endBlockpositionX"], area["endBlockpositionY"], area["endBlockpositionZ"]);
				-- Removes all blocks inside the area, slightly different function, since it also requires the new BlockID at the end (we use 0 for AIR in this case)
				world:setBlockDataInArea(area["startChunkpositionX"], area["startChunkpositionY"], area["startChunkpositionZ"], area["startBlockpositionX"], area["startBlockpositionY"], area["startBlockpositionZ"], area["endChunkpositionX"], area["endChunkpositionY"], area["endChunkpositionZ"], area["endBlockpositionX"], area["endBlockpositionY"], area["endBlockpositionZ"], 0);
				-- Send success message to player
				event.player:sendTextMessage("[#00FF00]Area "..area["areaName"].." successfully cleaned up!");
			else
				event.player:sendTextMessage("[#FF0000]You must enter an area first or provide the areaname!");
			end
			
		-- Command /fillarea to fill up an area with terrain or air
		elseif cmd[1] == "/fillarea" then
			if #cmd >= 3 then
				local area = nil;
				
				-- Find the area
				for key,value in pairs(areas) do
					if value["areaName"] == cmd[2] then
						area = value;
						break;
					end
				end
				
				if StringUtils:isInteger(cmd[3]) then
					local terraintype = tonumber(cmd[3]);
					if area ~= nil then
						world:setTerrainDataInArea(area["startChunkpositionX"], area["startChunkpositionY"], area["startChunkpositionZ"], area["startBlockpositionX"], area["startBlockpositionY"], area["startBlockpositionZ"], area["endChunkpositionX"], area["endChunkpositionY"], area["endChunkpositionZ"], area["endBlockpositionX"], area["endBlockpositionY"], area["endBlockpositionZ"], terraintype);
						event.player:sendTextMessage("[#00FF00]Area "..area["areaName"].." successfully filled up with "..terraintype);
					else
						event.player:sendTextMessage("[#FF0000]Area "..cmd[2].." not found!");
					end
				else
					event.player:sendTextMessage("[#FF0000]You must provide a numeric terraintype id");
				end
			else
				event.player:sendTextMessage("[#FF0000]Use /fillarea [AreaName] [TerrainType] [#B0B0B0](use 0 for AIR)");
			end
		
		-- If command was not found, send a notification to the player. Eventually you want to
		-- remove this line when you are using more than 1 scripts (with different command listeners)
		--else
			--event.player:sendTextMessage("[#B0B0B0]Unknown command");
		end
	end
end
addEvent("PlayerCommand", onPlayerCommand);
