function onPlayerCommand(event)
		-- All following commands are only usable when the player is an admin!
		if event.player:isAdmin() == false then
			--event.player:sendTextMessage("[#FF0000]You are not an admin");
			return;
		end
		
		-- Split the command string
		local cmd = StringUtils:explode(event.command, " ");

		-- Command /showportals to visualize all existing portals
		if cmd[1] == "/showportals" then
			local world = getWorld();
			local playerPortals = {};
			for key,value in pairs(portals) do
				local portal = {};
				portal[1] = value["portalID"];
				portal[2] = value["startChunkpositionX"];
				portal[3] = value["startChunkpositionY"];
				portal[4] = value["startChunkpositionZ"];
				portal[5] = value["startBlockpositionX"];
				portal[6] = value["startBlockpositionY"];
				portal[7] = value["startBlockpositionZ"];
				portal[8] = value["endChunkpositionX"];
				portal[9] = value["endChunkpositionY"];
				portal[10] = value["endChunkpositionZ"];
				portal[11] = value["endBlockpositionX"];
				portal[12] = value["endBlockpositionY"];
				portal[13] = value["endBlockpositionZ"];
				if tonumber(value["destinationID"]) ~= -1 then
					portal[14] = 0x0000FF00;
				else
					portal[14] = 0xFFFF0000;
				end
				event.player:addWorldElement(value["portalText"]);
			
				table.insert(playerPortals, portal);
			end
			event.player:setAttribute("portalsVisible", true);
			event.player:createAreas(playerPortals);
			event.player:showAllAreas();
			
		-- Command /hideportals to hide all visualized portals
		elseif cmd[1] == "/hideportals" then
			local portalIds = {};
			if portals == nil then
				return;
			end
			--if portals[12] == nil then
			--	return;
			--end
			for key,value in pairs(portals) do
				table.insert(portalIds, value["portalID"]);
			end
			event.player:hideAreas(portalIds);
			event.player:setAttribute("portalsVisible", false);			
		end
			
		-- Command /selectportal to select the area that will be used as a portal
		if cmd[1] == "/selectportal" then
			-- This is a Callback function, so we have to provide a function as parameter
			-- which is called when the callback is done
			event.player:enableMarkingSelector(function() end);
			
			event.player:sendYellMessage("Select the area and type \"/createportal\" to save it");
					
		-- Command /portalhelp gives a help text about portal creation
		elseif cmd[1] == "/portalhelp" then
			event.player:sendTextMessage("[#00FF00]Portal help");
			event.player:sendTextMessage("[#00FF00]Use /selectportal to select the area that will function as a portal");
			event.player:sendTextMessage("[#00FF00]Use /createportal [destinationPortalID or -1] [portalName]  to create the portal, if the portal is a destination portal then use \"-1\" as ID");
			event.player:sendTextMessage("[#00FF00]Use /listportals to see a list of portals to get the right id for the detination portal");
			event.player:sendTextMessage("[#00FF00]Use /showportals to visualize the portals");
			event.player:sendTextMessage("[#00FF00]Use /hideportals to hide the visualized portals");

		-- Command /listportals gives a list of portals
		elseif cmd[1] == "/listportals" then
			local limit = 9;
			local result = database:query("SELECT count(*) as count FROM portals")
			local db_count = result:getInt("count");
			local page_max = math.ceil(db_count / limit);
			local page_now = 1;

			if #cmd == 2 then
				page_now = tonumber(cmd[2]);
			end
			
			if page_now <= page_max then
				local start = ((page_now - 1) * limit);

				event.player:sendTextMessage("[#ff0000]Portal Positions");
				event.player:sendTextMessage("[#00ff12]-------------------------------------------------------")

				local result = database:query("SELECT * FROM portals LIMIT "..start..", "..limit);
				while result:next() do
					event.player:sendTextMessage("[#ff0000]"..result:getString("name")..", ID="..result:getInt("ID")..", Destination="..result:getInt("destinationID"));
				end
			
				event.player:sendTextMessage("[#00ff12]-------------------------------------------------------")
				if page_now == page_max then
					event.player:sendTextMessage("Page ".. page_now .." / ".. page_max);
				else
					event.player:sendTextMessage("Page ".. page_now .." / ".. page_max .."       Next Page Command: /listportals "..(page_now + 1));
				end
			end
	
		-- Command /createportal to save the area you have defined previously
		elseif cmd[1] == "/createportal" then
			if #cmd >= 3 then
				-- Provide a Callback-function, since it can't be triggered immediately, only after we receive the response from the player
				event.player:disableMarkingSelector(function(markingEvent)
					if markingEvent ~= false then
						local portal = {};
						portal["playerID"] = markingEvent.player:getDBID();
						local length = string.len(cmd[1] .. " " .. cmd[2] .. " ");
						portal["portalName"] = string.sub(event.command, tonumber(length)+1);
						portal["startChunkpositionX"] = markingEvent.startChunkpositionX;
						portal["startChunkpositionY"] = markingEvent.startChunkpositionY;
						portal["startChunkpositionZ"] = markingEvent.startChunkpositionZ;
						portal["startBlockpositionX"] = markingEvent.startBlockpositionX;
						portal["startBlockpositionY"] = markingEvent.startBlockpositionY;
						portal["startBlockpositionZ"] = markingEvent.startBlockpositionZ;
						
						portal["endChunkpositionX"] = markingEvent.endChunkpositionX;
						portal["endChunkpositionY"] = markingEvent.endChunkpositionY;
						portal["endChunkpositionZ"] = markingEvent.endChunkpositionZ;
						portal["endBlockpositionX"] = markingEvent.endBlockpositionX;
						portal["endBlockpositionY"] = markingEvent.endBlockpositionY;
						portal["endBlockpositionZ"] = markingEvent.endBlockpositionZ;
						portal["destinationID"] = tonumber(cmd[2]);
						
						adjustPortalPositions(portal);
						calculateGlobalPortalPosition(portal);
						
						local tpX = (portal["globalEndPositionX"] - ((portal["globalEndPositionX"] - portal["globalStartPositionX"]) / 100 / 2));
						local tpY = (portal["globalEndPositionY"] - ((portal["globalEndPositionY"] - portal["globalStartPositionY"]) / 100 / 2));
						local tpZ = (portal["globalEndPositionZ"] - ((portal["globalEndPositionZ"] - portal["globalStartPositionZ"]) / 100 / 2));
						portal["portalText"] = World:create3DText("[#FFFF00]"..portal["portalName"], tpX, tpY + 1.5, tpZ, 5, 0x00000000, true, true);
						
						database:queryupdate("INSERT INTO portals(name, startChunkpositionX, startChunkpositionY, startChunkpositionZ, startBlockpositionX, startBlockpositionY, startBlockpositionZ, endChunkpositionX, endChunkpositionY, endChunkpositionZ, endBlockpositionX, endBlockpositionY, endBlockpositionZ, playerID, destinationID) VALUES ('".. portal["portalName"] .."', '".. portal["startChunkpositionX"] .."', '".. portal["startChunkpositionY"] .."', '".. portal["startChunkpositionZ"] .."', '".. portal["startBlockpositionX"] .."', '".. portal["startBlockpositionY"] .."', '".. portal["startBlockpositionZ"] .."', '".. portal["endChunkpositionX"] .."', '".. portal["endChunkpositionY"] .."', '".. portal["endChunkpositionZ"] .."', '".. portal["endBlockpositionX"] .."', '".. portal["endBlockpositionY"] .."', '".. portal["endBlockpositionZ"] .."', '".. markingEvent.player:getDBID() .. "', '".. portal["destinationID"] .."')");
						local insertID = database:getLastInsertID();
						portal["portalID"] = insertID;
						portals[insertID] = portal;
						
						if event.player:getAttribute("portalsVisible") == true then
							local color = 0x0000FF00;
							if tonumber(portal["destinationID"]) == -1 then
								color = 0xFFFF0000;
							end
							event.player:createArea(insertID, portal["startChunkpositionX"], portal["startChunkpositionY"], portal["startChunkpositionZ"], portal["startBlockpositionX"], portal["startBlockpositionY"], portal["startBlockpositionZ"], portal["endChunkpositionX"], portal["endChunkpositionY"], portal["endChunkpositionZ"], portal["endBlockpositionX"], portal["endBlockpositionY"], portal["endBlockpositionZ"], color);
							event.player:showArea(insertID);
							event.player:addWorldElement(portal["portalText"]);
						end
						event.player:sendTextMessage("[#00FF00]Portal successfully created with ID " .. insertID);
					end
				end);
			else
				event.player:sendTextMessage("[#FF0000]Use /createportal [DestinationPortalID] [PortalName]");
			end

		-- Command /removeportal removes a portal from the database
		elseif cmd[1] == "/removeportal" then
			if #cmd == 2 then
				local result = database:query("SELECT count(*) as count FROM portals where destinationID = " .. cmd[2]);
				local db_count = result:getInt("count");
				if db_count > 0 then
					event.player:sendTextMessage("[#FF0000]The portal was used as a destination portal, there will be portals that go nowhere now!");
				end
				portals[tonumber(cmd[2])] = nil;
				
				database:queryupdate("DELETE FROM portals WHERE ID = " .. cmd[2]);
				if event.player:getAttribute("portalsVisible") == true then
					event.player:destroyArea(tonumber(cmd[2]));
				end
				event.player:sendTextMessage("Portal with ID "..cmd[2].." is removed!");
			else
				event.player:sendTextMessage("[#FF0000]Use /removeportal [PortalID]");
			end

		end
end
addEvent("PlayerCommand", onPlayerCommand);