-- Includes
include("listener/playerListener.lua");
include("listener/commandListener.lua");

-- Global variables
database = getDatabase();
server = getServer();
world = getWorld();
properties = getProperty("config.properties");
portals = {};
portalLoaded = false;

--- Script enable event.
-- This event is triggered when the script is loaded.
-- From this point on, the script gets notified about
-- all events and is able to call serverside functions.
function onEnable()
	print("PORTAL script started!");
	
	-- Create database tables "areas" and "rights" if they don't exist already
	database:queryupdate("CREATE TABLE IF NOT EXISTS 'portals' ('ID' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL , 'name' VARCHAR, 'startChunkpositionX' INTEGER, 'startChunkpositionY' INTEGER, 'startChunkpositionZ' INTEGER, 'startBlockpositionX' INTEGER, 'startBlockpositionY' INTEGER, 'startBlockpositionZ' INTEGER,'endChunkpositionX' INTEGER, 'endChunkpositionY' INTEGER, 'endChunkpositionZ' INTEGER, 'endBlockpositionX' INTEGER, 'endBlockpositionY' INTEGER, 'endBlockpositionZ' INTEGER, 'playerID' INTEGER, 'destinationID' INTEGER);");
	
	-- Receive all saved areas from database and store them in a global table
	local result = database:query("SELECT * FROM portals;");
	while result:next() do
		local portal = {};
		portal["portalID"] = result:getInt("ID"); 
		portal["playerID"] = result:getInt("playerID");
		portal["portalName"] = result:getString("name");
		portal["startChunkpositionX"] = result:getInt("startChunkpositionX");
		portal["startChunkpositionY"] = result:getInt("startChunkpositionY");
		portal["startChunkpositionZ"] = result:getInt("startChunkpositionZ");
		portal["startBlockpositionX"] = result:getInt("startBlockpositionX");
		portal["startBlockpositionY"] = result:getInt("startBlockpositionY");
		portal["startBlockpositionZ"] = result:getInt("startBlockpositionZ");
		
		portal["endChunkpositionX"] = result:getInt("endChunkpositionX");
		portal["endChunkpositionY"] = result:getInt("endChunkpositionY");
		portal["endChunkpositionZ"] = result:getInt("endChunkpositionZ");
		portal["endBlockpositionX"] = result:getInt("endBlockpositionX");
		portal["endBlockpositionY"] = result:getInt("endBlockpositionY");
		portal["endBlockpositionZ"] = result:getInt("endBlockpositionZ");
		portal["destinationID"] = result:getInt("destinationID");
		
		calculateGlobalPortalPosition(portal);
		
		local tpX = (portal["globalEndPositionX"] - ((portal["globalEndPositionX"] - portal["globalStartPositionX"]) / 100 / 2));
		local tpY = (portal["globalEndPositionY"] - ((portal["globalEndPositionY"] - portal["globalStartPositionY"]) / 100 / 2));
		local tpZ = (portal["globalEndPositionZ"] - ((portal["globalEndPositionZ"] - portal["globalStartPositionZ"]) / 100 / 2));
        				
		portal["portalText"] = World:create3DText("[#FFFF00]"..portal["portalName"], tpX, tpY + 1.5, tpZ, 5, 0x00000000, true, true);
		
		portals[result:getInt("ID")] = portal;
		--table.insert(areas, result:getInt("ID"), area);
	end
	
	-- Set a flag indicating that all areas are loaded
	portalLoaded = true;
end

--- Script disable event.
-- This event is triggered when the script is unloaded
-- which causes the script to stop.
function onDisable()
	print("PORTAL script stopped!");
end

--- Update tick event (frequently called event!)
-- This event is triggered every tick. Use this event
-- to update your script environment, as long as it requires frequent updates.
-- @param event The update event object
-- You can get the current tpf (event:getTpf()) or runningtime from it
function onUpdate(event)
	--print(server:getGameTimestamp());
	--print("TPF:" .. event:getTpf());
	--print("RUNNINGTIME:" .. event:getRunningTime());
end
addEvent("Update", onUpdate);

----------------------------------------------------------

--- Adjusts the position values of an area.
-- I.e. the start- and endposition will be swapped, if the
-- endposition is smaller than the startposition.
-- @param area The area object
function adjustPortalPositions(portal)
	local sx = ChunkUtils:getGlobalBlockPositionX(portal["startChunkpositionX"], portal["startBlockpositionX"]);
	local sy = ChunkUtils:getGlobalBlockPositionY(portal["startChunkpositionY"], portal["startBlockpositionY"]);
	local sz = ChunkUtils:getGlobalBlockPositionZ(portal["startChunkpositionZ"], portal["startBlockpositionZ"]);
	local ex = ChunkUtils:getGlobalBlockPositionX(portal["endChunkpositionX"], portal["endBlockpositionX"]);
	local ey = ChunkUtils:getGlobalBlockPositionY(portal["endChunkpositionY"], portal["endBlockpositionY"]);
	local ez = ChunkUtils:getGlobalBlockPositionZ(portal["endChunkpositionZ"], portal["endBlockpositionZ"]);
	if sx > ex then
		local t = portal["startChunkpositionX"];
		portal["startChunkpositionX"] = portal["endChunkpositionX"];
		portal["endChunkpositionX"] = t;
		t = portal["startBlockpositionX"];
		portal["startBlockpositionX"] = portal["endBlockpositionX"];
		portal["endBlockpositionX"] = t;
	end
	if sy > ey then
		local t = portal["startChunkpositionY"];
		portal["startChunkpositionY"] = portal["endChunkpositionY"];
		portal["endChunkpositionY"] = t;
		t = portal["startBlockpositionY"];
		portal["startBlockpositionY"] = portal["endBlockpositionY"];
		portal["endBlockpositionY"] = t;
	end
	if sz > ez then
		local t = portal["startChunkpositionZ"];
		portal["startChunkpositionZ"] = portal["endChunkpositionZ"];
		portal["endChunkpositionZ"] = t;
		t = portal["startBlockpositionZ"];
		portal["startBlockpositionZ"] = portal["endBlockpositionZ"];
		portal["endBlockpositionZ"] = t;
	end
end

--- Calculates the "global" start- and endposition of an portal.
-- @param portal The portal object
function calculateGlobalPortalPosition(portal)
	portal["globalStartPositionX"] = ChunkUtils:getGlobalBlockPositionX(portal["startChunkpositionX"], portal["startBlockpositionX"]);
	portal["globalStartPositionY"] = ChunkUtils:getGlobalBlockPositionY(portal["startChunkpositionY"], portal["startBlockpositionY"]);
	portal["globalStartPositionZ"] = ChunkUtils:getGlobalBlockPositionZ(portal["startChunkpositionZ"], portal["startBlockpositionZ"]);
	portal["globalEndPositionX"] = ChunkUtils:getGlobalBlockPositionX(portal["endChunkpositionX"], portal["endBlockpositionX"]);
	portal["globalEndPositionY"] = ChunkUtils:getGlobalBlockPositionY(portal["endChunkpositionY"], portal["endBlockpositionY"]);
	portal["globalEndPositionZ"] = ChunkUtils:getGlobalBlockPositionZ(portal["endChunkpositionZ"], portal["endBlockpositionZ"]);
end

--- Returns the area at the provided position.
-- @param chunkoffsetx The X offset position of the chunk
-- @param chunkoffsety The Y offset position of the chunk
-- @param chunkoffsetz The Z offset position of the chunk
-- @param blockpositionx The X blockposition within the chunk
-- @param blockpositiony The Y blockposition within the chunk
-- @param blockpositionz The Z blockposition within the chunk
-- @return The area at the provided position, or nil if no area was found
function getCurrentportal(chunkoffsetx, chunkoffsety, chunkoffsetz, blockpositionx, blockpositiony, blockpositionz)
	local portal = nil;
	for key,value in pairs(portals) do
		if AreaUtils:isPointInArea3D(chunkoffsetx, chunkoffsety, chunkoffsetz, blockpositionx, blockpositiony, blockpositionz, value["startChunkpositionX"], value["startChunkpositionY"], value["startChunkpositionZ"], value["startBlockpositionX"], value["startBlockpositionY"], value["startBlockpositionZ"], value["endChunkpositionX"], value["endChunkpositionY"], value["endChunkpositionZ"], value["endBlockpositionX"], value["endBlockpositionY"], value["endBlockpositionZ"]) then
			if portal == nil then
				portal = value;
			else
				if value["globalStartPositionX"] >= portal["globalStartPositionX"] and value["globalStartPositionY"] >= portal["globalStartPositionY"] and value["globalStartPositionZ"] >= portal["globalStartPositionZ"] and value["globalEndPositionX"] <= portal["globalEndPositionX"] and value["globalEndPositionY"] <= portal["globalEndPositionY"] and value["globalEndPositionZ"] <= portal["globalEndPositionZ"] then
					portal = value;
				end
			end
		end
	end
	return portal;
end

----------------------------------------------------------

--- Used to find out if the provided table
-- contains the specified value.
-- @param tab The table
-- @param value The value you're looking for
-- @return True if the value exists in the table, false if not
function tableContains(tab, value)
	for i = 1, #tab, 1 do
		if tab[i] == value then
			return true;
		end
	end
	return false;
end

--- Used to remove a value from the provided table.
-- @param tab The table
-- @param value The value you want to remove
function tableRemove(tab, value)
	for i = 1, #tab, 1 do
		if tab[i] == value then
			table.remove(tab, i);
		end
	end
end
