
--- Player connect event.
-- This event is triggered when a player connects to the server. Note that the
-- player is currently in the loadingscreen at the moment this event is triggered,
-- so it's useless to display anything on the players screen.
-- @param event The event object. Cancel the event to prevent the player to connect
function onPlayerConnect(event)
	event.player:setAttribute("portals", {});
	event.player:setAttribute("portalsVisible", false);
end
addEvent("PlayerConnect", onPlayerConnect);

--- Player change position event (frequently called event!)
-- This event is called everytime the player changes his position.
-- @param event The event object. Cancel the event to teleport the player back to his old position
function onPlayerChangePosition(event)
	--- if portalLoaded ~= true and event.player:getPlayerGroup() == "Surveyor" then 
	---	return; 
	--- end
	
	for key,value in pairs(portals) do
		if value ~= nil then
			if AreaUtils:isPointInArea3D(event.player:getPosition(), value["startChunkpositionX"], value["startChunkpositionY"], value["startChunkpositionZ"], value["startBlockpositionX"], value["startBlockpositionY"], value["startBlockpositionZ"], value["endChunkpositionX"], value["endChunkpositionY"], value["endChunkpositionZ"], value["endBlockpositionX"], value["endBlockpositionY"], value["endBlockpositionZ"]) then
				local destportal = portals[tonumber(value["destinationID"])];
				if destportal ~= nil then
					if destportal["destinationID"] == -1 then
						local tpX = (destportal["globalEndPositionX"] - ((destportal["globalEndPositionX"] - destportal["globalStartPositionX"]) / 100 / 2));
						local tpY = (destportal["globalEndPositionY"] - ((destportal["globalEndPositionY"] - destportal["globalStartPositionY"]) / 100 / 2));
						local tpZ = (destportal["globalEndPositionZ"] - ((destportal["globalEndPositionZ"] - destportal["globalStartPositionZ"]) / 100 / 2));
						event.player:setPosition(tpX, tpY, tpZ);
					end
				end
			end
		end
	end
end
addEvent("PlayerChangePosition", onPlayerChangePosition);
