/*
 * Decompiled with CFR 0.152.
 */
package fullscreentest;

import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class Window
extends JFrame {
    private JButton bCopy;
    private final JTextArea console = new JTextArea();
    private JScrollPane scrollPane;

    public static void main(String[] args) {
        Window window = new Window();
        window.setVisible(true);
        window.setLocationRelativeTo(null);
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] displayModes = device.getDisplayModes();
        if (displayModes == null) {
            window.print("NO DISPLAYMODES AVAILABLE");
        } else {
            for (DisplayMode dm : displayModes) {
                String s = dm.getWidth() + "x" + dm.getHeight() + " @ " + dm.getBitDepth() + "bpp " + dm.getRefreshRate() + "hz";
                window.print(s + "\n");
                System.out.println(s);
            }
        }
    }

    public Window() {
        this.initComponents();
        this.console.setEditable(false);
    }

    public void print(String output) {
        this.console.append(output);
        this.console.setCaretPosition(this.console.getDocument().getLength());
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.bCopy = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Fullscreentest - JIWGames");
        this.console.setColumns(20);
        this.console.setFont(new Font("Monospaced", 0, 18));
        this.console.setLineWrap(true);
        this.console.setRows(5);
        this.console.setCursor(new Cursor(2));
        this.scrollPane.setViewportView(this.console);
        this.bCopy.setText("Copy to clipboard");
        this.bCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Window.this.bCopyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 430, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bCopy, -2, 156, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 472, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bCopy).addContainerGap()));
        this.pack();
    }

    private void bCopyActionPerformed(ActionEvent evt) {
        this.console.requestFocusInWindow();
        this.console.selectAll();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.console.getText()), null);
    }
}

