function onEnable()
	print("GPS loaded successfully!");	
end

-- Global variables

--server = getServer();
world = getWorld();
-- 180 / PI
rad2deg	= 57.295779513;

--From a script by yahgiggle and richies for rising citys server

function onPlayerConnect(event)
	local labelgpsInfo = Gui:createLabel("");
	labelgpsInfo:setX(0.02);
	labelgpsInfo:setY(0.160);	
	labelgpsInfo:setFontColor(0xFFFFFFFF);
	labelgpsInfo:setBackgroundColor(0x0000007f);
	labelgpsInfo:setFontsize(18);
	labelgpsInfo:setPivot(0);
	event.player:setAttribute("gpsInfoLabel", labelgpsInfo);
	event.player:addGuiElement(labelgpsInfo);
	event.player:setAttribute("GUIgpsInfo", true);
end
addEvent("PlayerConnect", onPlayerConnect);

function onPlayerCommand(event)
	local command = event.command;
	local cmd = StringUtils:explode(command, " ");
	
        if cmd[1] == "/gps" then
		if event.player:getAttribute("GUIgpsInfo") then
			event.player:setAttribute("GUIgpsInfo", false);
		else
			event.player:setAttribute("GUIgpsInfo", true);
		end
		
	end	
end
addEvent("PlayerCommand", onPlayerCommand);

function onPlayerChangePosition(event)
	local labelgpsInfo = event.player:getAttribute("gpsInfoLabel");
	if event.player:getAttribute("GUIgpsInfo") then
		-- Get the rotation of the player
		local playerRot	= event.player:getViewDirection();
		local rotX		= playerRot.x;
		local rotZ		= playerRot.z;
		local scale		= math.sqrt(rotX*rotX + rotZ*rotZ);
		local scaledZ	= math.acos(rotZ / scale) * rad2deg;
		if rotX > 0 then
			scaledZ = 360 - scaledZ;
		end
		scaledZ	= math.floor(scaledZ + 0.5);

		-- Get the position of the player
		local playerPos = event.player:getPosition();
		local posE = math.floor(-playerPos.x + 0.5);
		local posN = math.floor(playerPos.z + 0.5);
		local posH = math.floor(playerPos.y + 0.5);

		labelgpsInfo:setText(scaledZ.."° ("..posN.."N,"..posE.."E) h"..posH);
	else
		labelgpsInfo:setText("");		
	end
end
addEvent("PlayerChangePosition", onPlayerChangePosition);
