/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StringSerializer
extends Serializer {
    public String readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len < 0) {
            return null;
        }
        char[] characters = new char[len];
        for (int i = 0; i < len; ++i) {
            characters[i] = data.getChar();
        }
        return new String(characters);
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        String string = (String)object;
        buffer.putShort((short)string.length());
        for (int i = 0; i < string.length(); ++i) {
            buffer.putChar(string.charAt(i));
        }
    }

    public String clone(Object object) {
        if (object == null) {
            return null;
        }
        return (String)object;
    }
}

