/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LongArraySerializer
extends Serializer {
    public long[] readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len == -1) {
            return null;
        }
        long[] array = new long[len &= 0xFFFF];
        for (int i = 0; i < len; ++i) {
            array[i] = data.getLong();
        }
        return array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        long[] array = (long[])object;
        if (array.length > 65534) {
            throw new UnsupportedOperationException("Array length too large for FieldSerializer: " + array.length);
        }
        buffer.putShort((short)array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.putLong(array[i]);
        }
    }

    public long[] clone(Object object) {
        if (object == null) {
            return null;
        }
        long[] array = (long[])object;
        long[] clone = new long[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }
}

