/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DoubleArraySerializer
extends Serializer {
    public double[] readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len == -1) {
            return null;
        }
        double[] array = new double[len &= 0xFFFF];
        for (int i = 0; i < len; ++i) {
            array[i] = data.getDouble();
        }
        return array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        double[] array = (double[])object;
        if (array.length > 65534) {
            throw new UnsupportedOperationException("Array length too large for FieldSerializer: " + array.length);
        }
        buffer.putShort((short)array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.putDouble(array[i]);
        }
    }

    public double[] clone(Object object) {
        if (object == null) {
            return null;
        }
        double[] array = (double[])object;
        double[] clone = new double[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }
}

