/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.kernel.udp;

import de.jiw.network.Network;
import de.jiw.network.base.Connection;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.Kernel;
import de.jiw.network.kernel.KernelAdapter;
import de.jiw.network.kernel.udp.NamedThreadFactory;
import de.jiw.network.kernel.udp.UdpEndpoint;
import de.jiw.network.message.RawPacket;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class UdpKernel
extends Kernel {
    private DatagramSocket socket;
    protected ConcurrentHashMap<SocketAddress, UdpEndpoint> socketEndpoints = new ConcurrentHashMap();
    protected ConcurrentLinkedQueue<UdpEndpoint> pending = new ConcurrentLinkedQueue();
    private ThreadPoolExecutor writer;
    private byte[] buffer = new byte[96];

    public UdpKernel(int id, InetSocketAddress address) {
        super(id, address);
        this.setType(Network.ChannelType.UDP);
        this.setDaemon(true);
        this.setName("UdpKernel Port: " + address.getPort());
        this.writer = (ThreadPoolExecutor)Executors.newFixedThreadPool(2, new NamedThreadFactory(this.toString() + "-writer"));
    }

    @Override
    public void initialize() throws IOException {
        if (this.isInitialized()) {
            throw new BindException("Socket already initialized, Port: " + this.address.getPort());
        }
        this.socket = new DatagramSocket(this.address);
        this.active.set(true);
        this.start();
        System.out.println("StartUp UdpKernel Port: " + this.address.getPort());
    }

    @Override
    public void terminate() throws IOException, InterruptedException {
        this.active.set(false);
        this.interrupt();
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public boolean isInitialized() {
        return this.socket != null;
    }

    @Override
    public void wakeupSelector() {
    }

    protected void cancel(UdpEndpoint endpoint) throws IOException {
        this.socketEndpoints.remove(endpoint.getAddress());
        this.pendingCloseEvents.add(endpoint);
        this.adapter.addAdapterEvent(KernelAdapter.Events.CLOSE);
    }

    protected Endpoint getEndpoint(SocketAddress address) {
        UdpEndpoint endpoint = this.socketEndpoints.get(address);
        if (endpoint == null) {
            endpoint = new UdpEndpoint(this, this.getNextEndpointId(), address, this.socket);
            this.socketEndpoints.put(address, endpoint);
        }
        return endpoint;
    }

    public void removeEndpoint(UdpEndpoint endpoint) {
        this.socketEndpoints.remove(endpoint.getAddress());
        this.pending.remove(endpoint);
    }

    protected void write(DatagramPacket packet) throws IOException {
        this.writer.execute(new MessageWriter(packet));
    }

    private void read(DatagramPacket packet) throws IOException {
        Endpoint endpoint = this.getEndpoint(packet.getSocketAddress());
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, data, 0, data.length);
        RawPacket raw = new RawPacket(endpoint, data, false);
        this.adapter.dispatcher.execute(raw);
    }

    @Override
    public void run() {
        while (this.active.get()) {
            try {
                DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
                this.socket.receive(packet);
                this.read(packet);
            }
            catch (Exception e) {
                if (!this.active.get()) continue;
                if (this.socket != null) {
                    e.printStackTrace();
                    continue;
                }
                System.out.println("UdpKernel Socket == null");
            }
        }
    }

    @Override
    public void broadcast(Connection exclusion, ByteBuffer data) {
        if (exclusion == null) {
            for (UdpEndpoint endpoint : this.socketEndpoints.values()) {
                if (!endpoint.isReady()) continue;
                endpoint.send(data.duplicate());
            }
        } else {
            Endpoint ep = exclusion.getEndpoint(this.id);
            for (UdpEndpoint endpoint : this.socketEndpoints.values()) {
                if (!endpoint.isReady() || endpoint.getId() == ep.getId()) continue;
                endpoint.send(data.duplicate());
            }
        }
    }

    protected class MessageWriter
    implements Runnable {
        private final DatagramPacket packet;

        public MessageWriter(DatagramPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            try {
                UdpKernel.this.socket.send(this.packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

