/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.kernel.tcp;

import de.jiw.network.Network;
import de.jiw.network.base.Connection;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.Kernel;
import de.jiw.network.kernel.KernelAdapter;
import de.jiw.network.kernel.tcp.TcpEndpoint;
import de.jiw.network.message.RawPacket;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TcpKernel
extends Kernel {
    protected ServerSocketChannel serverChannel;
    protected Selector selector;
    protected ConcurrentHashMap<Integer, TcpEndpoint> endpoints = new ConcurrentHashMap();
    protected ConcurrentHashMap<TcpEndpoint, SelectionKey> endpointKeys = new ConcurrentHashMap();
    protected ConcurrentLinkedQueue<TcpEndpoint> pending = new ConcurrentLinkedQueue();
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);

    public TcpKernel(int id, InetSocketAddress address) {
        super(id, address);
        this.setDaemon(true);
        this.setType(Network.ChannelType.TCP);
        this.setName("TcpKernel Port: " + address.getPort());
    }

    @Override
    public void initialize() throws IOException {
        if (this.isInitialized()) {
            throw new BindException("Selector already initialized, Port: " + this.address.getPort());
        }
        AbstractSelector socketSelector = SelectorProvider.provider().openSelector();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.serverChannel.socket().bind(this.address);
        this.serverChannel.register(socketSelector, 16);
        this.selector = socketSelector;
        this.active.set(true);
        this.start();
        System.out.println("StartUp TcpKernel Port: " + this.address.getPort());
    }

    @Override
    public void terminate() throws IOException, InterruptedException {
        this.active.set(false);
        this.serverChannel.close();
        this.wakeupSelector();
        this.join();
        this.selector.close();
        for (Endpoint endpoint : this.pending) {
            endpoint.terminate();
        }
        for (Endpoint endpoint : this.endpoints.values()) {
            endpoint.terminate();
        }
        for (Endpoint endpoint : this.endpointKeys.keySet()) {
            endpoint.terminate();
        }
        this.endpoints.clear();
        this.pending.clear();
        this.endpointKeys.clear();
    }

    public boolean isInitialized() {
        return this.selector != null;
    }

    @Override
    public void wakeupSelector() {
        this.selector.wakeup();
    }

    public void removeEndpoint(TcpEndpoint endpoint) {
        this.endpoints.remove(endpoint.getId());
        this.endpointKeys.remove(endpoint);
        this.pending.remove(endpoint);
    }

    protected void accept(SelectionKey key) throws IOException {
        ServerSocketChannel channel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = channel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        SelectionKey endKey = socketChannel.register(this.selector, 1);
        TcpEndpoint p = this.addEndpoint(socketChannel);
        endKey.attach(p);
        this.endpointKeys.put(p, endKey);
    }

    protected void read(SelectionKey key) throws IOException {
        int size;
        TcpEndpoint endpoint = (TcpEndpoint)key.attachment();
        SocketChannel channel = (SocketChannel)key.channel();
        this.readBuffer.clear();
        try {
            size = channel.read(this.readBuffer);
        }
        catch (Exception e) {
            System.out.println("SERVER: TcpKernel Exception " + e.toString());
            this.cancel(key, channel, endpoint);
            return;
        }
        if (size == -1) {
            this.cancel(key, channel, endpoint);
            return;
        }
        byte[] dataCopy = new byte[size];
        System.arraycopy(this.readBuffer.array(), 0, dataCopy, 0, size);
        RawPacket env = new RawPacket(endpoint, dataCopy, true);
        this.addPacketsReceive(1);
        this.addBytesReceive(size);
        this.adapter.dispatcher.execute(env);
    }

    protected void write(SelectionKey key) throws IOException {
        TcpEndpoint endpoint = (TcpEndpoint)key.attachment();
        SocketChannel channel = (SocketChannel)key.channel();
        if (endpoint.isCloseRequested() && !endpoint.hasPending()) {
            return;
        }
        ByteBuffer data = endpoint.peekPending();
        if (data == null) {
            throw new NullPointerException("TcpEndpoint has no pending data");
        }
        try {
            this.addBytesSend(data.capacity());
            this.addPacketsSend(1);
            channel.write(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cancel(key, channel, endpoint);
            return;
        }
        if (data.remaining() == 0) {
            endpoint.removePending();
        }
        if (!endpoint.hasPending()) {
            key.interestOps(1);
        }
    }

    protected void cancel(SelectionKey key, SocketChannel channel, TcpEndpoint endpoint) throws IOException {
        key.cancel();
        channel.close();
        this.endpointKeys.remove(endpoint);
        endpoint.setClosed(true);
        this.pendingCloseEvents.add(endpoint);
        this.adapter.addAdapterEvent(KernelAdapter.Events.CLOSE);
        this.adapter.removeMessageProtocol(endpoint);
    }

    protected void removeEndpoint(SelectionKey key, SocketChannel channel, TcpEndpoint endpoint) throws IOException {
        key.cancel();
        channel.close();
        this.endpointKeys.remove(endpoint);
        this.endpoints.remove(endpoint.getId());
        endpoint.getHostedConnection().removeEndpoint(endpoint);
        endpoint.setClosed(true);
    }

    protected TcpEndpoint addEndpoint(SocketChannel channel) throws IOException {
        int endpointId = this.getNextEndpointId();
        TcpEndpoint e = new TcpEndpoint(endpointId, this, channel);
        this.endpoints.put(e.getId(), e);
        return e;
    }

    @Override
    public void run() {
        while (this.active.get()) {
            try {
                for (Map.Entry<TcpEndpoint, SelectionKey> entry : this.endpointKeys.entrySet()) {
                    TcpEndpoint endpoint = entry.getKey();
                    if (endpoint.isCloseRequested() && !endpoint.hasPending() && !endpoint.isClosed()) {
                        this.cancel(entry.getValue(), endpoint.channel, endpoint);
                        continue;
                    }
                    if (!endpoint.hasPending()) continue;
                    entry.getValue().interestOps(4);
                }
                this.selector.select();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    iterator.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                if (!this.active.get()) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void broadcast(Connection exclusion, ByteBuffer data) {
        if (exclusion == null) {
            for (TcpEndpoint endpoint : this.endpoints.values()) {
                if (!endpoint.isReady()) continue;
                endpoint.send(data.duplicate());
            }
        } else {
            Endpoint ep = exclusion.getEndpoint(this.id);
            for (TcpEndpoint endpoint : this.endpoints.values()) {
                if (!endpoint.isReady() || endpoint.getId() == ep.getId()) continue;
                endpoint.send(data.duplicate());
            }
        }
    }
}

