/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.kernel;

import de.jiw.network.NetworkServer;
import de.jiw.network.base.Connection;
import de.jiw.network.base.HostedConnection;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.Kernel;
import de.jiw.network.kernel.udp.NamedThreadFactory;
import de.jiw.network.listener.MessageListener;
import de.jiw.network.message.ChannelReconnectMessage;
import de.jiw.network.message.ClientRegisterChannelMessage;
import de.jiw.network.message.ClientRegisterCompletedMessage;
import de.jiw.network.message.ClientRegisterMessage;
import de.jiw.network.message.DisconnectMessage;
import de.jiw.network.message.Message;
import de.jiw.network.message.RawPacket;
import de.jiw.network.message.ServerPingMessage;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelAdapter
extends Thread {
    public NetworkServer server;
    public ThreadPoolExecutor dispatcher;
    protected AtomicBoolean active = new AtomicBoolean(true);
    private Kernel kernel;
    private boolean reliable;
    private ConcurrentHashMap<Endpoint, MessageProtocol> messageProtocols = new ConcurrentHashMap();
    private LinkedBlockingQueue<Events> eventsPending = new LinkedBlockingQueue();
    private static final Logger logger = Logger.getLogger(KernelAdapter.class.getName());

    public KernelAdapter(NetworkServer server, Kernel kernel, boolean reliable, int threadCount) {
        this.server = server;
        this.kernel = kernel;
        this.reliable = reliable;
        this.kernel.setAdapter(this);
        this.setDaemon(true);
        this.setName("KernelAdapter: " + kernel.getName());
        this.dispatcher = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadCount, new NamedThreadFactory(this.toString() + "-dispatcher"));
        System.out.println("ThreadPoolSize " + this.kernel.getAddress().getPort() + " " + (reliable ? "TCP" : "UDP") + ": " + this.dispatcher.getMaximumPoolSize() + " (" + threadCount + ")");
    }

    public boolean isReliable() {
        return this.reliable;
    }

    public InetSocketAddress getKernelAddress() {
        return this.kernel.getAddress();
    }

    protected void connectionClosed(Endpoint endpoint) {
        this.messageProtocols.remove(endpoint);
        this.server.removeClient(endpoint);
    }

    public MessageProtocol getMessageProtocol(Endpoint endpoint) {
        if (!this.reliable) {
            return new MessageProtocol();
        }
        MessageProtocol result = this.messageProtocols.get(endpoint);
        if (result == null) {
            result = new MessageProtocol();
            this.messageProtocols.put(endpoint, result);
        }
        return result;
    }

    public void removeMessageProtocol(Endpoint endpoint) {
        this.messageProtocols.remove(endpoint);
    }

    public void dispatch(Endpoint endpoint, Message message) {
        Class<?> messageclass = message.getClass();
        if (message.isDefaultMessage()) {
            if (messageclass == ServerPingMessage.class) {
                HostedConnection source = this.server.getConnection(endpoint);
                if (source != null) {
                    source.calcPing((ServerPingMessage)message);
                }
                return;
            }
            if (messageclass == ClientRegisterMessage.class) {
                System.out.println("dispatch: ClientRegisterMessage");
                this.server.registerClient(this, endpoint, (ClientRegisterMessage)message);
                return;
            }
            if (messageclass == ClientRegisterChannelMessage.class) {
                System.out.println("dispatch: ClientRegisterChannelMessage " + this.kernel.getType().name() + "  Port:" + this.kernel.getAddress().getPort());
                this.server.registerClientChannel(this, endpoint, (ClientRegisterChannelMessage)message);
                return;
            }
            if (messageclass == DisconnectMessage.class) {
                System.out.println("Server DisconnectMessage");
                HostedConnection source = this.server.getConnection(endpoint);
                source.closeConnection(true);
                return;
            }
            if (messageclass == ChannelReconnectMessage.class) {
                System.out.println("ChannelReconnectMessage Port " + this.kernel.getAddress().getPort());
                ChannelReconnectMessage m = (ChannelReconnectMessage)message;
                HostedConnection source = null;
                if (source != null) {
                    System.out.println("source.setChannel (Port " + this.kernel.getAddress().getPort() + ")");
                    Endpoint end = source.getEndpoint(this.server.getChannel(this));
                    int channel = this.server.getChannel(this);
                    source.setChannel(channel, endpoint);
                    endpoint.setHostedConnection(source);
                    source.setReconnectingChannel(this.kernel, false);
                    this.server.replaceEndpointConnection(end, endpoint);
                    endpoint.setReady(true);
                    source.onReconnect(channel);
                } else {
                    source = this.server.getConnection(m.uuid);
                    System.out.println(source);
                    if (source != null) {
                        Endpoint end = source.getEndpoint(this.server.getChannel(this));
                        source.setChannel(this.server.getChannel(this), endpoint);
                        endpoint.setHostedConnection(source);
                        this.server.replaceEndpointConnection(end, endpoint);
                        end.close(true);
                        logger.log(Level.INFO, "Replaced HostedConnection endpoint (Port {0})", this.kernel.getAddress().getPort());
                    } else {
                        logger.log(Level.WARNING, "Recieved ChannelReconnectMessage (Port {0}) from unpending endpoint: {1}  message: {2}", new Object[]{this.kernel.getAddress().getPort(), endpoint.getId(), messageclass.getName()});
                        endpoint.close(true);
                    }
                }
                return;
            }
            if (messageclass == ClientRegisterCompletedMessage.class) {
                ClientRegisterCompletedMessage m = (ClientRegisterCompletedMessage)message;
                HostedConnection source = this.server.getPendingConnection(m.id);
                if (source != null) {
                    if (source.checkEndpoints()) {
                        this.server.onClientConnectCompleted(source, m.id);
                    } else {
                        source.closeConnection(true);
                    }
                } else {
                    logger.log(Level.WARNING, "Recieved ClientRegisterCompletedMessage from unpending endpoint: {0}  message: {1}", new Object[]{endpoint.getId(), messageclass.getName()});
                }
                return;
            }
        }
        try {
            HostedConnection source = this.server.getConnection(endpoint);
            if (source == null) {
                if (this.reliable) {
                    logger.log(Level.WARNING, "Recieved message from unconnected endpoint: {0}  message: {1}", new Object[]{endpoint.getId(), messageclass.getName()});
                }
                return;
            }
            MessageListener listener = this.server.getMessageListener(messageclass);
            if (listener == null) {
                logger.log(Level.WARNING, "No message listener found for message: {0}", messageclass.getName());
                return;
            }
            listener.messageReceived(source, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startUp() {
        try {
            this.kernel.initialize();
            this.active.set(true);
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public void terminate() throws Exception {
        this.active.set(false);
        this.eventsPending.clear();
        this.eventsPending.add(Events.WAKEUP);
        this.kernel.terminate();
    }

    public void addAdapterEvent(Events event) {
        this.eventsPending.add(event);
    }

    public void broadcast(Connection exclusion, ByteBuffer data) {
        this.kernel.broadcast(exclusion, data);
    }

    @Override
    public void run() {
        while (this.active.get()) {
            try {
                switch (this.eventsPending.take()) {
                    case READ: {
                        RawPacket raw = this.kernel.read();
                        if (this.kernel.getRawPacketsCount() > 10) {
                            System.out.println(this.toString() + " RawPacktes >10:" + this.kernel.getRawPacketsCount());
                        }
                        if (raw != null) break;
                    }
                    case CLOSE: {
                        Endpoint endpoint = this.kernel.pendingCloseEvents.poll();
                        if (endpoint == null) break;
                        this.connectionClosed(endpoint);
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!this.active.get()) {
                    return;
                }
                e.printStackTrace();
            }
        }
    }

    public static enum Events {
        READ,
        WRITE,
        CLOSE,
        WAKEUP;

    }
}

