/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.connector.tcp;

import de.jiw.network.base.MessageProtocol;
import de.jiw.network.connector.Connector;
import de.jiw.network.message.ChannelReconnectMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpConnector
extends Connector {
    private InetAddress address;
    private int port;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SocketAddress remoteAddress;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private int timeout = 0;
    private boolean reconnecting = false;
    private boolean closing = false;
    private boolean close = false;

    @Override
    public boolean start(InetAddress address, int port) {
        this.address = address;
        this.port = port;
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(address, port), 7000);
            this.remoteAddress = this.socket.getRemoteSocketAddress();
            this.socket.setTcpNoDelay(true);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.connected.set(true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void reconnect() {
        System.out.println("Client reconnect, port:" + this.port);
        this.reconnecting = true;
        Thread reconnectThread = new Thread("ReconnectThread_" + this.port){
            public boolean active;
            public int tries;
            {
                this.active = true;
                this.tries = 0;
            }

            @Override
            public void run() {
                while (this.active) {
                    try {
                        TcpConnector.this.socket = new Socket();
                        TcpConnector.this.socket.connect(new InetSocketAddress(TcpConnector.this.address, TcpConnector.this.port), 1500);
                        TcpConnector.this.remoteAddress = TcpConnector.this.socket.getRemoteSocketAddress();
                        TcpConnector.this.socket.setTcpNoDelay(true);
                        TcpConnector.this.inputStream = TcpConnector.this.socket.getInputStream();
                        TcpConnector.this.outputStream = TcpConnector.this.socket.getOutputStream();
                        TcpConnector.this.connected.set(true);
                        TcpConnector.this.outputStream.write(MessageProtocol.messageToBuffer(new ChannelReconnectMessage(TcpConnector.this.adapter.getClient().getId(), TcpConnector.this.adapter.getClient().getUUID()), ByteBuffer.allocate(65535)).array());
                        this.active = false;
                        TcpConnector.this.reconnecting = false;
                        TcpConnector.this.adapter.getClient().reconnect();
                        System.out.println("RECONNECT DONE");
                    }
                    catch (Exception e) {
                        if (TcpConnector.this.close) {
                            this.active = false;
                            TcpConnector.this.reconnecting = false;
                            TcpConnector.this.adapter.connectorClose(null);
                            return;
                        }
                        if (this.tries++ >= 10) {
                            System.out.println("Unable to reconnect to server!");
                            e.printStackTrace();
                            TcpConnector.this.adapter.connectorTimeout();
                            TcpConnector.this.adapter.connectorClose(new ReconnectException("Unable to reconnect to server: " + e.toString()));
                            this.active = false;
                            TcpConnector.this.reconnecting = false;
                            return;
                        }
                        try {
                            System.out.println("retrying reconnect...");
                            1.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                    }
                }
            }
        };
        reconnectThread.setDaemon(true);
        reconnectThread.start();
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    @Override
    public void close() {
        this.close = true;
        try (Socket temp = this.socket;){
            this.socket = null;
            this.connected.set(false);
            System.out.println("Closing socket for: " + this.remoteAddress);
        }
        catch (Exception e) {
            System.out.println("Error closing socket for: " + this.remoteAddress);
        }
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public void write(ByteBuffer data) {
        if (this.socket == null || this.reconnecting || this.closing) {
            return;
        }
        try {
            this.outputStream.write(data.array());
        }
        catch (IOException e) {
            System.out.println("Error writing to connection: " + this.remoteAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int read(byte[] store) {
        if (this.socket == null || this.reconnecting || this.closing) {
            return -1;
        }
        try {
            int count = this.inputStream.read(store);
            this.timeout = 0;
            if (count < 0) {
                System.out.println("TcpConnector gracefully closed");
                this.closing = true;
                this.adapter.connectorClose(null);
                return -1;
            }
            return count;
        }
        catch (SocketTimeoutException e) {
            ++this.timeout;
            if (this.timeout > 15) {
                this.adapter.connectorTimeout();
                this.adapter.connectorClose(e);
            }
            return -1;
        }
        catch (SocketException e) {
            if (e.getMessage().equalsIgnoreCase("socket closed")) {
                this.adapter.connectorClose(null);
                return -1;
            }
            this.adapter.connectorClose(e);
            return -1;
        }
        catch (Exception e) {
            this.adapter.connectorClose(e);
            return -1;
        }
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    public class ReconnectException
    extends Exception {
        public ReconnectException() {
        }

        public ReconnectException(String s) {
            super(s);
        }
    }
}

