/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.basic;

import de.jiw.network.basic.BasicConnection;
import de.jiw.network.basic.BasicServer;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class BasicKernel
extends Thread {
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private InetSocketAddress address;
    private AtomicBoolean active = new AtomicBoolean(false);
    private BasicServer server;
    protected ConcurrentHashMap<BasicConnection, SelectionKey> endpointKeys = new ConcurrentHashMap();

    public BasicKernel(BasicServer server, InetSocketAddress address) {
        this.setDaemon(true);
        this.setName("BasicKernel_Port: " + address.getPort());
        this.address = address;
        this.server = server;
    }

    public void initialize() throws IOException {
        if (this.isInitialized()) {
            throw new BindException("BasicKernel already initialized, Port: " + this.address.getPort());
        }
        AbstractSelector socketSelector = SelectorProvider.provider().openSelector();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.serverChannel.socket().bind(this.address);
        this.serverChannel.register(socketSelector, 16);
        this.selector = socketSelector;
        this.active.set(true);
        this.start();
        System.out.println("StartUp BasicKernel Port: " + this.address.getPort());
    }

    public boolean isInitialized() {
        return this.selector != null;
    }

    public void wakeupSelector() {
        this.selector.wakeup();
    }

    public void terminate() throws IOException, InterruptedException {
        this.active.set(false);
        this.serverChannel.close();
        this.selector.wakeup();
        this.join();
        this.selector.close();
        this.endpointKeys.clear();
    }

    public void cancel(SelectionKey key, SocketChannel channel, BasicConnection connection) throws IOException {
        key.cancel();
        channel.close();
        this.endpointKeys.remove(connection);
        if (this.server.stateListener != null) {
            this.server.stateListener.onClientDisconnect(connection);
        }
    }

    protected void accept(SelectionKey key) throws IOException {
        ServerSocketChannel channel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = channel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        SelectionKey endKey = socketChannel.register(this.selector, 1);
        BasicConnection endpoint = new BasicConnection(socketChannel, this);
        endKey.attach(endpoint);
        this.endpointKeys.put(endpoint, endKey);
        if (this.server.stateListener != null) {
            this.server.stateListener.onClientConnect(endpoint);
        }
    }

    protected void read(SelectionKey key) throws IOException, IllegalStateException {
        block7: {
            int size;
            BasicConnection endpoint = (BasicConnection)key.attachment();
            SocketChannel channel = (SocketChannel)key.channel();
            this.readBuffer.clear();
            try {
                size = channel.read(this.readBuffer);
            }
            catch (Exception e) {
                System.out.println("SERVER: BasicKernel Exception " + e.toString());
                this.cancel(key, channel, endpoint);
                return;
            }
            if (size == -1) {
                this.cancel(key, channel, endpoint);
            } else {
                try {
                    byte[] dataCopy = new byte[size];
                    System.arraycopy(this.readBuffer.array(), 0, dataCopy, 0, size);
                    ByteBuffer dataBuffer = ByteBuffer.wrap(dataCopy);
                    endpoint.protocol.addBuffer(dataBuffer);
                    while (endpoint.protocol.hasMessages()) {
                        this.server.receiveMessage(endpoint, endpoint.protocol.getMessage());
                    }
                }
                catch (Exception e) {
                    endpoint.protocol.resetCurrent();
                    if (endpoint.errorcount++ < 5) break block7;
                    this.cancel(key, channel, endpoint);
                }
            }
        }
    }

    public void write(SelectionKey key) throws IOException {
        BasicConnection endpoint = (BasicConnection)key.attachment();
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer data = endpoint.outboundTake();
        if (data == null) {
            throw new NullPointerException("BasicConnection has no pending data");
        }
        try {
            channel.write(data);
        }
        catch (Exception e) {
            this.cancel(key, channel, endpoint);
        }
        if (!endpoint.hasPending()) {
            key.interestOps(1);
        }
    }

    @Override
    public void run() {
        while (this.active.get()) {
            try {
                for (Map.Entry<BasicConnection, SelectionKey> entry : this.endpointKeys.entrySet()) {
                    if (!entry.getKey().channel.isConnected() || !entry.getValue().isValid() || entry.getKey().isCloseRequested() && !entry.getKey().hasPending()) {
                        this.cancel(entry.getValue(), entry.getKey().channel, entry.getKey());
                        continue;
                    }
                    if (!entry.getKey().hasPending()) continue;
                    entry.getValue().interestOps(4);
                }
                this.selector.select();
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey key = iterator.next();
                    iterator.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                if (!this.active.get()) continue;
                e.printStackTrace();
            }
        }
    }
}

