/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.basic;

import de.jiw.network.Network;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.basic.BasicClientStateListener;
import de.jiw.network.listener.MessageListener;
import de.jiw.network.message.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicClient
extends Thread {
    private InputStream dataInput;
    private OutputStream dataOutput;
    private Socket socket;
    private ConcurrentHashMap<Class<? extends Message>, MessageListener> listenerMappings = new ConcurrentHashMap();
    private MessageProtocol messageProtocol = new MessageProtocol();
    private AtomicBoolean active = new AtomicBoolean(false);
    private BasicClientStateListener stateListener = null;
    private ConcurrentHashMap<String, Object> sessionData = new ConcurrentHashMap();
    private byte[] readArray = new byte[8192];

    public BasicClient(String ip, int port) throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(ip, port), 5000);
        this.dataOutput = this.socket.getOutputStream();
        this.dataInput = this.socket.getInputStream();
        this.active.set(true);
        this.setDaemon(true);
        this.start();
        if (this.stateListener != null) {
            this.stateListener.onConnect();
        }
    }

    public void addMessageListener(MessageListener listener, Class<? extends Message> c) {
        this.listenerMappings.put(c, listener);
    }

    public void addStateListener(BasicClientStateListener listener) {
        this.stateListener = listener;
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.sessionData.remove(name);
        }
        return this.sessionData.put(name, value);
    }

    public <T> Object getAttribute(String name) {
        return this.sessionData.get(name);
    }

    public void close() throws IOException {
        this.socket.close();
        this.active.set(false);
        if (this.stateListener != null) {
            this.stateListener.onDisconnect();
        }
    }

    public void send(Message m) {
        try {
            this.dataOutput.write(MessageProtocol.messageToBuffer(m, Network.sharedBuffer.get()).array());
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                try {
                    int size = this.dataInput.read(this.readArray);
                    if (size <= 0) continue;
                    byte[] dataCopy = new byte[size];
                    System.arraycopy(this.readArray, 0, dataCopy, 0, size);
                    ByteBuffer data = ByteBuffer.wrap(dataCopy);
                    this.messageProtocol.addBuffer(data);
                    while (this.messageProtocol.hasMessages()) {
                        Message m = this.messageProtocol.getMessage();
                        this.listenerMappings.get(m.getClass()).messageReceived(this, m);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close();
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(BasicClient.class.getName()).log(Level.SEVERE, null, e);
        }
    }
}

