/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.message.ServerInfoMessage;
import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ServerInfoSerializer
extends Serializer {
    public ServerInfoMessage readObject(ByteBuffer data, Class c) throws IOException {
        int i;
        ServerInfoMessage message = new ServerInfoMessage();
        message.id = data.getInt();
        int len = data.get();
        if (len >= 0) {
            message.tcpPorts = new int[len];
            for (i = 0; i < len; ++i) {
                message.tcpPorts[i] = data.getInt();
            }
        } else {
            message.tcpPorts = null;
        }
        if ((len = data.get()) >= 0) {
            message.udpPorts = new int[len];
            for (i = 0; i < len; ++i) {
                message.udpPorts[i] = data.getInt();
            }
        } else {
            message.udpPorts = null;
        }
        if ((len = data.get()) >= 0) {
            byte[] buffer = new byte[len];
            data.get(buffer);
            message.uuid = new String(buffer, "UTF-8");
        } else {
            message.uuid = null;
        }
        return message;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        int i;
        ServerInfoMessage message = (ServerInfoMessage)object;
        buffer.putInt(message.id);
        if (message.tcpPorts != null) {
            buffer.put((byte)message.tcpPorts.length);
            for (i = 0; i < message.tcpPorts.length; ++i) {
                buffer.putInt(message.tcpPorts[i]);
            }
        } else {
            buffer.put((byte)-1);
        }
        if (message.udpPorts != null) {
            buffer.put((byte)message.udpPorts.length);
            for (i = 0; i < message.udpPorts.length; ++i) {
                buffer.putInt(message.udpPorts[i]);
            }
        } else {
            buffer.put((byte)-1);
        }
        if (message.uuid == null) {
            buffer.put((byte)-1);
        } else {
            byte[] bytes = message.uuid.getBytes("UTF-8");
            buffer.put((byte)bytes.length);
            buffer.put(bytes);
        }
    }

    public Object clone(Object object) {
        return null;
    }
}

