/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class IntArraySerializer
extends Serializer {
    public int[] readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len == -1) {
            return null;
        }
        int[] array = new int[len &= 0xFFFF];
        for (int i = 0; i < len; ++i) {
            array[i] = data.getInt();
        }
        return array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        int[] array = (int[])object;
        if (array.length > 65534) {
            throw new UnsupportedOperationException("Array length too large for FieldSerializer: " + array.length);
        }
        buffer.putShort((short)array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.putInt(array[i]);
        }
    }

    public int[] clone(Object object) {
        if (object == null) {
            return null;
        }
        int[] array = (int[])object;
        int[] clone = new int[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }
}

