/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FloatArraySerializer
extends Serializer {
    public float[] readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len == -1) {
            return null;
        }
        float[] array = new float[len &= 0xFFFF];
        for (int i = 0; i < len; ++i) {
            array[i] = data.getFloat();
        }
        return array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        float[] array = (float[])object;
        if (array.length > 65534) {
            throw new UnsupportedOperationException("Array length too large for FieldSerializer: " + array.length);
        }
        buffer.putShort((short)array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.putFloat(array[i]);
        }
    }

    public float[] clone(Object object) {
        if (object == null) {
            return null;
        }
        float[] array = (float[])object;
        float[] clone = new float[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }
}

