/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.kernel.tcp;

import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.Kernel;
import de.jiw.network.kernel.tcp.TcpKernel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TcpEndpoint
extends Endpoint {
    protected final int id;
    protected final Kernel kernel;
    protected final SocketChannel channel;
    private SocketAddress address;
    private boolean closeRequest = false;
    private boolean closed = false;
    private ConcurrentLinkedQueue<ByteBuffer> outbound = new ConcurrentLinkedQueue();

    public TcpEndpoint(int id, Kernel kernel, SocketChannel channel) throws IOException {
        this.id = id;
        this.kernel = kernel;
        this.channel = channel;
        this.address = channel.getRemoteAddress();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    public boolean isConnected() {
        return this.channel.socket().isConnected();
    }

    @Override
    public void terminate() {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeEndpoint() {
        try {
            this.channel.close();
            if (this.kernel instanceof TcpKernel) {
                ((TcpKernel)this.kernel).removeEndpoint(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close(boolean force) {
        this.closeRequest = true;
        if (force) {
            this.outbound.clear();
        }
        this.kernel.wakeupSelector();
    }

    public boolean isCloseRequested() {
        return this.closeRequest;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed(boolean close) {
        this.closeRequest = true;
        this.closed = close;
    }

    @Override
    public void send(ByteBuffer data) {
        this.send(data, true);
    }

    @Override
    public void send(ByteBuffer data, boolean wakeup) {
        if (this.isCloseRequested()) {
            return;
        }
        this.outbound.add(data);
        if (wakeup) {
            this.kernel.wakeupSelector();
        }
    }

    protected ByteBuffer peekPending() {
        return this.outbound.peek();
    }

    protected ByteBuffer removePending() {
        return this.outbound.poll();
    }

    protected boolean hasPending() {
        return !this.outbound.isEmpty();
    }

    @Override
    public SocketAddress getAddress() {
        return this.address;
    }
}

