/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.connector.udp;

import de.jiw.network.connector.Connector;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class UdpConnector
extends Connector {
    private DatagramSocket socket;
    private SocketAddress remoteAddress;
    private InetAddress address;
    private int port;
    private AtomicBoolean connected = new AtomicBoolean(false);

    @Override
    public boolean start(InetAddress address, int port) {
        System.out.println("UDP " + address + "  " + port);
        try {
            this.socket = new DatagramSocket(0);
            this.remoteAddress = new InetSocketAddress(address, port);
            this.socket.connect(this.remoteAddress);
            this.connected.set(true);
            this.address = address;
            this.port = port;
            return true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void reconnect() {
        try {
            this.socket = new DatagramSocket(0);
            this.socket.connect(this.remoteAddress);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public void close() {
        this.connected.set(false);
        this.socket.close();
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public int read(byte[] store) {
        try {
            DatagramPacket packet = new DatagramPacket(store, store.length);
            this.socket.receive(packet);
            return packet.getLength();
        }
        catch (Exception e) {
            if (this.connected.get()) {
                System.out.println("UDP READ ERROR");
                e.printStackTrace();
            }
            return -1;
        }
    }

    @Override
    public void write(ByteBuffer data) {
        block2: {
            try {
                byte[] array = data.array();
                DatagramPacket packet = new DatagramPacket(array, 0, array.length, this.socket.getRemoteSocketAddress());
                this.socket.send(packet);
            }
            catch (Exception e) {
                if (!this.connected.get()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

