/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.connector;

import de.jiw.network.Network;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.connector.Connector;
import de.jiw.network.connector.ConnectorAdapter;
import de.jiw.network.message.Message;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorReadThread
extends Thread {
    private ConnectorAdapter adapter;
    private Connector connector;
    protected AtomicBoolean active = new AtomicBoolean(false);
    private MessageProtocol messageProtocol;
    private byte[] readArray;
    private static final Logger logger = Logger.getLogger(ConnectorReadThread.class.getName());

    public ConnectorReadThread(ConnectorAdapter adapter, Connector connector) {
        this.adapter = adapter;
        this.connector = connector;
        this.setDaemon(true);
        this.setName("ConnectorReadThread Type:" + adapter.getType().name() + " Port:" + adapter.getPort());
        this.messageProtocol = new MessageProtocol();
    }

    public void open() {
        this.readArray = this.adapter.getType() == Network.ChannelType.TCP ? new byte[8192] : new byte[96];
        this.active.set(true);
        this.start();
    }

    public void close() {
        this.active.set(false);
    }

    private MessageProtocol getMessageProtocol() {
        if (this.adapter.isReliable()) {
            return this.messageProtocol;
        }
        return new MessageProtocol();
    }

    @Override
    public void run() {
        while (this.active.get()) {
            try {
                Message m;
                ByteBuffer data;
                MessageProtocol protocol = this.getMessageProtocol();
                if (this.adapter.isReliable()) {
                    int size = this.connector.read(this.readArray);
                    if (size <= 0) continue;
                    byte[] dataCopy = new byte[size];
                    System.arraycopy(this.readArray, 0, dataCopy, 0, size);
                    data = ByteBuffer.wrap(dataCopy);
                } else {
                    byte[] dataCopy = new byte[96];
                    int size = this.connector.read(dataCopy);
                    if (size <= 0) continue;
                    data = ByteBuffer.wrap(dataCopy, 0, size);
                }
                int count = protocol.addBuffer(data);
                if (count == 0 && !this.adapter.isReliable()) {
                    logger.log(Level.SEVERE, "RawPacket (UDP) contained incomplete data: {0}", this.readArray == null ? "null" : Arrays.toString(this.readArray));
                    continue;
                }
                while ((m = protocol.getMessage()) != null) {
                    this.adapter.dispatch(data.capacity(), m);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.adapter.getClient() == null || ++this.adapter.getClient().errorcounter <= 50) continue;
                this.adapter.getClient().disconnect(false);
            }
        }
    }
}

