/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.basic;

import de.jiw.network.basic.BasicConnection;
import de.jiw.network.basic.BasicKernel;
import de.jiw.network.basic.BasicServerStateListener;
import de.jiw.network.listener.MessageListener;
import de.jiw.network.message.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BasicServer {
    private BasicKernel kernel;
    private ConcurrentHashMap<Class<? extends Message>, MessageListener> listenerMappings = new ConcurrentHashMap();
    protected BasicServerStateListener stateListener = null;

    public void startServer(InetSocketAddress address) throws IOException {
        this.kernel = new BasicKernel(this, address);
        this.kernel.initialize();
    }

    public void stopServer() throws IOException, InterruptedException {
        this.kernel.terminate();
    }

    public void broadcast(Message m) {
        for (Map.Entry<BasicConnection, SelectionKey> entry : this.kernel.endpointKeys.entrySet()) {
            entry.getKey().send(m);
        }
    }

    public void addMessageListener(MessageListener listener, Class<? extends Message> c) {
        this.listenerMappings.put(c, listener);
    }

    public void addStateListener(BasicServerStateListener listener) {
        this.stateListener = listener;
    }

    public MessageListener getMessageListener(Class<? extends Message> c) {
        return this.listenerMappings.get(c);
    }

    protected void receiveMessage(BasicConnection connection, Message msg) {
        this.listenerMappings.get(msg.getClass()).messageReceived(connection, msg);
    }
}

