/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.basic;

import de.jiw.network.Network;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.basic.BasicKernel;
import de.jiw.network.message.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BasicConnection {
    protected SocketChannel channel;
    protected MessageProtocol protocol;
    private ConcurrentLinkedQueue<ByteBuffer> outbound = new ConcurrentLinkedQueue();
    private boolean closed = false;
    private boolean iscloserequested = false;
    private BasicKernel kernel;
    public int errorcount = 0;
    private ConcurrentHashMap<String, Object> sessionData = new ConcurrentHashMap();

    public BasicConnection(SocketChannel channel, BasicKernel kernel) {
        this.channel = channel;
        this.protocol = new MessageProtocol();
        this.kernel = kernel;
        System.out.println(this.protocol);
    }

    public void send(Message m) {
        if (this.closed || this.iscloserequested) {
            return;
        }
        try {
            this.outbound.add(MessageProtocol.messageToBuffer(m, Network.sharedBuffer.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.kernel.wakeupSelector();
    }

    public boolean hasPending() {
        return !this.outbound.isEmpty();
    }

    public ByteBuffer outboundTake() {
        return this.outbound.poll();
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.sessionData.remove(name);
        }
        return this.sessionData.put(name, value);
    }

    public <T> Object getAttribute(String name) {
        return this.sessionData.get(name);
    }

    public boolean isCloseRequested() {
        return this.iscloserequested;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean force) {
        try {
            if (force) {
                this.channel.close();
                this.closed = true;
            } else {
                this.iscloserequested = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

