/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.base;

import de.jiw.network.message.Message;
import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MessageProtocol {
    private ByteBuffer current;
    private int size;
    private Byte carry;
    private ConcurrentLinkedQueue<byte[]> rawData = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Message> messages = new ConcurrentLinkedQueue();

    public static ByteBuffer createNewByteBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size + 2 + 2);
        buffer.putShort((short)(size + 2));
        return buffer;
    }

    public static ByteBuffer messageToBuffer(Message message, ByteBuffer buffer) throws IOException {
        buffer.rewind();
        buffer.position(2);
        Serializer.write(buffer, message);
        buffer.putShort(0, (short)(buffer.position() - 2));
        byte[] array = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, array, 0, buffer.position());
        ByteBuffer bb = ByteBuffer.wrap(array);
        return bb;
    }

    public void addRawData(byte[] data) {
        this.rawData.add(data);
    }

    public byte[] getRawData() {
        return this.rawData.poll();
    }

    public int addBuffer(ByteBuffer buffer) throws IOException, IllegalStateException {
        while (buffer.remaining() > 0) {
            if (this.current == null) {
                if (this.carry != null) {
                    byte high = this.carry;
                    byte low = buffer.get();
                    this.size = (high & 0xFF) << 8 | low & 0xFF;
                    this.carry = null;
                } else {
                    if (buffer.remaining() < 2) {
                        this.carry = buffer.get();
                        break;
                    }
                    this.size = buffer.getShort();
                }
                this.current = ByteBuffer.allocate(this.size & 0xFFFF);
            }
            if (this.current.remaining() <= buffer.remaining()) {
                int extra = buffer.remaining() - this.current.remaining();
                buffer.limit(buffer.position() + this.current.remaining());
                this.current.put(buffer);
                this.current.flip();
                buffer.limit(buffer.position() + extra);
                this.createMessage(this.current);
                this.current = null;
                continue;
            }
            this.current.put(buffer);
        }
        return this.messages.size();
    }

    protected void createMessage(ByteBuffer buffer) throws IOException, IllegalStateException {
        Message message = Serializer.read(buffer);
        this.messages.add(message);
    }

    public Message getMessage() {
        return this.messages.poll();
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public void resetCurrent() {
        this.current = null;
    }
}

