/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.base;

import de.jiw.network.Network;
import de.jiw.network.base.Connection;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.Kernel;
import de.jiw.network.message.DisconnectMessage;
import de.jiw.network.message.Message;
import de.jiw.network.message.ServerPingMessage;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HostedConnection
implements Connection {
    private final int id;
    private final String uuid;
    private boolean closed;
    private int setChannelCount = 0;
    private int channelCount = 0;
    private Endpoint[] channels;
    private volatile long bytesSend = 0L;
    private volatile long bytesReceive = 0L;
    private volatile long packetsSend = 0L;
    private volatile long packetsReceive = 0L;
    private volatile short ping = 0;
    private volatile short pingClientServer = 0;
    private volatile short pingServerClient = 0;
    public int disconnectTimer = 0;
    public int connectionTimeout = 0;
    public int reconnectingTimer = 0;
    private boolean isReconnecting = false;
    private boolean disconnect = false;
    public int errorcounter = 0;
    private ConcurrentHashMap<Integer, ConcurrentLinkedQueue<ByteBuffer>> pendingMessages = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> sessionData = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Kernel> reconnectingKernel = new ConcurrentHashMap();

    public HostedConnection(int id, int channelCount, String uuid) {
        this.id = id;
        this.channelCount = channelCount;
        this.uuid = uuid;
        this.channels = new Endpoint[channelCount];
    }

    public Endpoint getChannel(int channel) {
        return this.channels[channel];
    }

    public void setChannel(int channel, Endpoint endpoint) {
        this.channels[channel] = endpoint;
        if (endpoint != null) {
            ConcurrentLinkedQueue<ByteBuffer> list = this.pendingMessages.get(channel);
            if (list != null) {
                while (!list.isEmpty()) {
                    ByteBuffer data = list.poll();
                    if (data == null) continue;
                    endpoint.send(data);
                    ++this.packetsSend;
                    this.bytesSend += (long)data.capacity();
                }
            }
            ++this.setChannelCount;
        }
    }

    public boolean hasChannel(int channel) {
        return this.channels[channel] != null;
    }

    public synchronized void removeChannel(int channel) {
        this.channels[channel] = null;
        --this.setChannelCount;
    }

    public synchronized void removeEndpoint(Endpoint point) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] == null || !this.channels[i].equals(point)) continue;
            this.channels[i] = null;
        }
        --this.setChannelCount;
    }

    public synchronized boolean hasEndpoints() {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] == null) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean checkEndpoints() {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete() {
        return this.setChannelCount == this.channels.length;
    }

    public boolean isDisconnecting() {
        return this.disconnect;
    }

    public void setReconnectingChannel(Kernel kernel, boolean set) {
        if (set) {
            this.reconnectingKernel.put(kernel.getKernelId(), kernel);
            this.isReconnecting = true;
        } else {
            this.reconnectingKernel.remove(kernel.getKernelId());
            if (this.reconnectingKernel.isEmpty()) {
                System.out.println("EMPTY");
                this.isReconnecting = false;
            }
        }
    }

    public boolean isChannelReconnecting(Kernel kernel) {
        return this.reconnectingKernel.get(kernel.getKernelId()) != null;
    }

    public boolean isChannelReconnecting(int kernelId) {
        return this.reconnectingKernel.get(kernelId) != null;
    }

    public boolean isReconnecting() {
        return this.isReconnecting;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Endpoint getEndpoint(int channel) {
        return this.channels[channel];
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.channels[0] == null ? null : this.channels[0].getKernel().getAddress();
    }

    @Override
    public void send(Message message) {
        this.send(0, message);
    }

    @Override
    public void send(int channel, Message message) {
        if (this.closed) {
            return;
        }
        try {
            this.send(channel, MessageProtocol.messageToBuffer(message, Network.sharedBuffer.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void send(int channel, ByteBuffer buffer) {
        if (this.closed) {
            return;
        }
        try {
            if (this.isChannelReconnecting(channel)) {
                ConcurrentLinkedQueue<ByteBuffer> list = this.pendingMessages.get(channel);
                if (list == null) {
                    list = new ConcurrentLinkedQueue();
                    list.add(buffer);
                    this.pendingMessages.put(channel, list);
                } else {
                    list.add(buffer);
                }
            } else {
                ++this.packetsSend;
                this.bytesSend += (long)buffer.capacity();
                this.channels[channel].send(buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized Endpoint[] getEndpoints() {
        return this.channels;
    }

    public boolean hasEndpoint(Endpoint endpoint) {
        for (Endpoint end : this.channels) {
            if (end != endpoint) continue;
            return true;
        }
        return false;
    }

    public void onReconnect(int channel) {
    }

    public void terminate() {
        this.closed = true;
        this.pendingMessages.clear();
        for (Endpoint p : this.channels) {
            if (p == null) continue;
            p.terminate();
        }
    }

    public void closeConnection(boolean force) {
        this.disconnect = true;
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Endpoint p : this.channels) {
            if (p == null) continue;
            p.close(force);
        }
    }

    @Override
    public void close(String reason) {
        this.pendingMessages.clear();
        if (reason != null) {
            DisconnectMessage m = new DisconnectMessage(reason);
            this.send(m);
        } else {
            this.closeConnection(true);
        }
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.sessionData.remove(name);
        }
        return this.sessionData.put(name, value);
    }

    @Override
    public <T> Object getAttribute(String name) {
        return this.sessionData.get(name);
    }

    public long getPacketsReceive() {
        return this.packetsReceive;
    }

    public long getBytesReceive() {
        return this.bytesReceive;
    }

    public long getPacketsSend() {
        return this.packetsSend;
    }

    public long getBytesSend() {
        return this.bytesSend;
    }

    public void addBytesSend(int count) {
        this.bytesSend += (long)count;
    }

    public void addPacketsSend(int count) {
        this.packetsSend += (long)count;
    }

    public void addBytesReceive(int count) {
        this.bytesReceive += (long)count;
    }

    public void addPacketsReceive(int count) {
        this.packetsReceive += (long)count;
    }

    @Override
    public short getPing() {
        return this.ping;
    }

    public short getClientServerPing() {
        return this.pingClientServer;
    }

    public short getServerClientPing() {
        return this.pingServerClient;
    }

    public void calcPing(ServerPingMessage msg) {
        long currentTime = System.currentTimeMillis();
        this.ping = (short)(currentTime - msg.serverSendTime);
        this.pingClientServer = (short)(currentTime - msg.clientSendTime);
        this.pingServerClient = (short)(msg.clientSendTime - msg.serverSendTime);
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }
}

