/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network;

import de.jiw.network.Network;
import de.jiw.network.Server;
import de.jiw.network.base.Connection;
import de.jiw.network.base.HostedConnection;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.KernelAdapter;
import de.jiw.network.kernel.tcp.TcpKernel;
import de.jiw.network.kernel.udp.UdpKernel;
import de.jiw.network.listener.MessageListener;
import de.jiw.network.listener.ServerStateListener;
import de.jiw.network.message.ClientRegisterChannelMessage;
import de.jiw.network.message.ClientRegisterMessage;
import de.jiw.network.message.DisconnectMessage;
import de.jiw.network.message.Message;
import de.jiw.network.message.ServerInfoMessage;
import de.jiw.network.message.ServerPingMessage;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NetworkServer
implements Server {
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private PingThread pingThread;
    public static final int CHANNEL_TCP = 0;
    public static final int CHANNEL_UDP = 1;
    private int defaultThreadCountTCP = 2;
    private int defaultThreadCountUDP = 2;
    private InetSocketAddress address;
    private String version;
    private CopyOnWriteArrayList<KernelAdapter> kernels = new CopyOnWriteArrayList();
    private boolean isRunning = false;
    private ConcurrentHashMap<Integer, HostedConnection> pendingConnections = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, HostedConnection> connections = new ConcurrentHashMap();
    private ConcurrentHashMap<Endpoint, HostedConnection> endpointConnections = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HostedConnection> uuidConnections = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<? extends Message>, MessageListener> listenerMappings = new ConcurrentHashMap();
    private CopyOnWriteArrayList<ServerStateListener> stateListeners = new CopyOnWriteArrayList();
    private ArrayList<Boolean> clientIds = new ArrayList();
    private int[] tcpPorts = null;
    private int[] udpPorts = null;
    private static final Logger logger = Logger.getLogger(NetworkServer.class.getName());

    public NetworkServer(InetSocketAddress address, String version, int defaultThreadCountTCP, int defaultThreadCountUDP) {
        System.out.println("NetworkServer version 0.6");
        this.clientIds.add(true);
        this.address = address;
        this.version = version;
        this.defaultThreadCountTCP = defaultThreadCountTCP;
        this.defaultThreadCountUDP = defaultThreadCountUDP;
        this.addChannel(address.getPort(), defaultThreadCountTCP, Network.ChannelType.TCP);
        this.addChannel(address.getPort(), defaultThreadCountUDP, Network.ChannelType.UDP);
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void addChannel(int port, Network.ChannelType type) {
        if (type == Network.ChannelType.TCP) {
            this.addChannel(port, this.defaultThreadCountTCP, type);
        } else {
            this.addChannel(port, this.defaultThreadCountUDP, type);
        }
    }

    @Override
    public void addChannel(int port, int threadCount, Network.ChannelType type) {
        if (this.isRunning) {
            throw new Error("Cannot add channel when server is already running!");
        }
        for (KernelAdapter kernel : this.kernels) {
            if (kernel.isReliable() != (type == Network.ChannelType.TCP) || kernel.getKernelAddress().getPort() != port) continue;
            throw new IllegalStateException("Port " + port + " is already used by another kernel!");
        }
        if (type == Network.ChannelType.TCP) {
            TcpKernel tcp = new TcpKernel(this.kernels.size(), new InetSocketAddress(this.address.getAddress(), port));
            this.kernels.add(new KernelAdapter(this, tcp, true, threadCount));
        } else if (type == Network.ChannelType.UDP) {
            UdpKernel udp = new UdpKernel(this.kernels.size(), new InetSocketAddress(this.address.getAddress(), port));
            this.kernels.add(new KernelAdapter(this, udp, false, threadCount));
        }
    }

    public void replaceEndpointConnection(Endpoint oldEnd, Endpoint newEnd) {
        HostedConnection con = this.endpointConnections.get(oldEnd);
        if (con == null) {
            return;
        }
        this.endpointConnections.remove(oldEnd);
        this.endpointConnections.put(newEnd, con);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void startServer() {
        int i;
        ArrayList<Integer> tcpPortList = new ArrayList<Integer>();
        ArrayList<Integer> udpPortList = new ArrayList<Integer>();
        int id = 0;
        for (KernelAdapter kernel : this.kernels) {
            if (kernel.isReliable()) {
                tcpPortList.add(id);
                tcpPortList.add(kernel.getKernelAddress().getPort());
            } else {
                udpPortList.add(id);
                udpPortList.add(kernel.getKernelAddress().getPort());
            }
            ++id;
        }
        this.tcpPorts = new int[tcpPortList.size() - 2];
        this.udpPorts = new int[udpPortList.size() - 2];
        for (i = 2; i < tcpPortList.size(); ++i) {
            this.tcpPorts[i - 2] = (Integer)tcpPortList.get(i);
        }
        for (i = 2; i < udpPortList.size(); ++i) {
            this.udpPorts[i - 2] = (Integer)udpPortList.get(i);
        }
        this.isRunning = true;
        for (KernelAdapter kernel : this.kernels) {
            kernel.startUp();
        }
        this.pingThread = new PingThread(this.kernels.get(1));
        this.executor.scheduleAtFixedRate(this.pingThread, 0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void stopServer() {
        this.isRunning = false;
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(2500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (HostedConnection connection : this.connections.values()) {
            connection.terminate();
        }
        for (HostedConnection connection : this.pendingConnections.values()) {
            connection.terminate();
        }
        for (HostedConnection connection : this.endpointConnections.values()) {
            connection.terminate();
        }
        for (Endpoint endpoint : this.endpointConnections.keySet()) {
            endpoint.terminate();
        }
        this.connections.clear();
        this.pendingConnections.clear();
        this.uuidConnections.clear();
        this.endpointConnections.clear();
        this.clientIds.clear();
        this.clientIds.add(true);
        this.tcpPorts = null;
        this.udpPorts = null;
        System.out.println("Stopping " + this.kernels.size() + " kernel adapters...");
        for (KernelAdapter kernel : this.kernels) {
            try {
                kernel.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.kernels.clear();
    }

    @Override
    public void addMessageListener(MessageListener listener, Class<? extends Message> c) {
        if (this.isRunning) {
            throw new Error("Cannot add messagelistener when server is already running!");
        }
        this.listenerMappings.put(c, listener);
    }

    @Override
    public MessageListener getMessageListener(Class<? extends Message> c) {
        return this.listenerMappings.get(c);
    }

    @Override
    public void addStateListener(ServerStateListener listener) {
        if (this.isRunning) {
            throw new Error("Cannot add state listener when server is already running!");
        }
        this.stateListeners.add(listener);
    }

    public void setEndpointHostedConnection(Endpoint endpoint, HostedConnection conn) {
        this.endpointConnections.put(endpoint, conn);
    }

    protected synchronized int nextClientId() {
        for (int i = 0; i < this.clientIds.size(); ++i) {
            boolean current = this.clientIds.get(i);
            if (current) continue;
            this.clientIds.set(i, true);
            return i;
        }
        this.clientIds.add(true);
        System.out.println("NEXT CLIENT ID: " + (this.clientIds.size() - 1));
        return this.clientIds.size() - 1;
    }

    protected synchronized void removeClientId(int id) {
        if (id >= this.clientIds.size()) {
            return;
        }
        this.clientIds.set(id, false);
    }

    public HostedConnection getPendingConnection(int endpointId) {
        return this.pendingConnections.get(endpointId);
    }

    public HostedConnection getConnection(Endpoint endpoint) {
        return this.endpointConnections.get(endpoint);
    }

    public HostedConnection getConnection(String uuid) {
        return this.uuidConnections.get(uuid);
    }

    @Override
    public Collection<HostedConnection> getConnections() {
        return this.endpointConnections.values();
    }

    @Override
    public Connection getConnection(int connectionID) {
        return this.connections.get(connectionID);
    }

    public int getChannel(KernelAdapter adapter) {
        return this.kernels.indexOf(adapter);
    }

    @Override
    public void broadcast(Message m) {
        this.broadcast(0, null, m);
    }

    @Override
    public void broadcast(Connection exclusion, Message m) {
        this.broadcast(0, exclusion, m);
    }

    @Override
    public void broadcast(int channel, Message m) {
        this.broadcast(channel, null, m);
    }

    @Override
    public void broadcast(int channel, Connection exclusion, Message m) {
        try {
            this.broadcast(channel, exclusion, MessageProtocol.messageToBuffer(m, Network.sharedBuffer.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void broadcast(int channel, Connection exclusion, ByteBuffer buffer) {
        block2: {
            try {
                this.kernels.get(channel).broadcast(exclusion, buffer);
            }
            catch (Exception e) {
                if (!this.isRunning()) break block2;
                e.printStackTrace();
            }
        }
    }

    protected void dispatch(HostedConnection source, Message message) {
        MessageListener listener = this.listenerMappings.get(message.getClass());
        if (listener == null) {
            logger.log(Level.WARNING, "No message listener found for message: {0}", message.getClass().getName());
            return;
        }
        listener.messageReceived(source, message);
    }

    public void registerClient(KernelAdapter adapter, Endpoint endpoint, ClientRegisterMessage message) {
        if (!this.version.equals(message.version)) {
            try {
                DisconnectMessage m = new DisconnectMessage("Client/Server version mismatch");
                endpoint.send(MessageProtocol.messageToBuffer(m, Network.sharedBuffer.get()));
                endpoint.close(false);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                endpoint.close(true);
                return;
            }
        }
        String uuid = UUID.randomUUID().toString();
        HostedConnection connection = new HostedConnection(this.nextClientId(), this.kernels.size(), uuid);
        connection.setChannel(this.getChannel(adapter), endpoint);
        endpoint.setHostedConnection(connection);
        this.pendingConnections.put(connection.getId(), connection);
        ServerInfoMessage infoMessage = new ServerInfoMessage(connection.getId(), this.tcpPorts, this.udpPorts, uuid);
        connection.send(infoMessage);
        for (ServerStateListener listener : this.stateListeners) {
            listener.connectionPending(this, connection);
        }
    }

    public void registerClientChannel(KernelAdapter adapter, Endpoint endpoint, ClientRegisterChannelMessage message) {
        HostedConnection connection = this.pendingConnections.get(message.id);
        if (connection == null) {
            logger.log(Level.WARNING, "No pending connection for client {0}", message.id);
            endpoint.terminate();
            return;
        }
        int channel = this.getChannel(adapter);
        if (message.type == 0) {
            connection.setChannel(channel, endpoint);
            System.out.println("SET HOSTED CONNECTION FOR CHANNEL: " + channel + "   " + connection);
            endpoint.setHostedConnection(connection);
        } else if (!connection.hasChannel(channel)) {
            connection.setChannel(channel, endpoint);
            endpoint.setHostedConnection(connection);
        }
        connection.send(channel, message);
    }

    public void onClientConnectCompleted(HostedConnection connection, int id) {
        try {
            System.out.println("registerClientChannel isComplete");
            this.pendingConnections.remove(id, connection);
            this.uuidConnections.put(connection.getUUID(), connection);
            this.connections.put(connection.getId(), connection);
            System.out.println("Endpoints length: " + connection.getEndpoints().length);
            for (Endpoint point : connection.getEndpoints()) {
                this.endpointConnections.put(point, connection);
                point.setReady(true);
                System.out.println("register endpoint: " + point + " " + connection.getId());
            }
            for (ServerStateListener listener : this.stateListeners) {
                listener.connectionAdded(this, connection);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "onClientConnectCompleted exception", e);
            connection.closeConnection(true);
        }
    }

    public void removeClient(Endpoint endpoint) {
        HostedConnection connection = this.endpointConnections.get(endpoint);
        if (connection != null) {
            this.endpointConnections.remove(endpoint);
            this.uuidConnections.remove(connection.getUUID());
        } else {
            HostedConnection epConnection = endpoint.getHostedConnection();
            if (epConnection == null) {
                return;
            }
            connection = this.pendingConnections.get(epConnection.getId());
            this.pendingConnections.remove(epConnection.getId());
            if (connection == null) {
                return;
            }
        }
        this.removeClient(connection, endpoint.getId(), endpoint);
    }

    public synchronized void removeClient(HostedConnection connection, int endpointID, Endpoint endpoint) {
        if (connection == null) {
            logger.log(Level.WARNING, "No hosted connection found for endpoint {0}", endpointID);
            return;
        }
        int channel = this.getChannel(endpoint.getKernel().getAdapter());
        connection.closeConnection(true);
        connection.removeChannel(channel);
        if (!connection.hasEndpoints()) {
            this.connections.remove(connection.getId());
            this.removeClientId(connection.getId());
            System.out.println("---------------------------");
            System.out.println("Client: " + connection.getId() + " removed");
            for (ServerStateListener listener : this.stateListeners) {
                listener.connectionRemoved(this, connection);
            }
        }
    }

    private class PingThread
    extends Thread {
        private KernelAdapter adapter;

        private PingThread(KernelAdapter adapter) {
            this.adapter = adapter;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                for (HostedConnection connection : NetworkServer.this.pendingConnections.values()) {
                    connection.connectionTimeout += 2;
                    if (connection.disconnectTimer <= 30) continue;
                    connection.closeConnection(true);
                    logger.log(Level.WARNING, "Client {0} connection timeout", connection.getId());
                }
                for (HostedConnection connection : NetworkServer.this.connections.values()) {
                    if (connection.isReconnecting()) {
                        connection.reconnectingTimer += 2;
                        if (connection.reconnectingTimer > 15) {
                            System.out.println("Reconnect Timer");
                            connection.closeConnection(true);
                        }
                    }
                    if (connection.isDisconnecting()) continue;
                    ServerPingMessage message = new ServerPingMessage(System.currentTimeMillis(), connection.getServerClientPing(), connection.getClientServerPing(), connection.getPing());
                    connection.send(1, message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

