/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.message.ChannelReconnectMessage;
import de.jiw.network.message.ClientRegisterChannelMessage;
import de.jiw.network.message.ClientRegisterCompletedMessage;
import de.jiw.network.message.ClientRegisterMessage;
import de.jiw.network.message.DisconnectMessage;
import de.jiw.network.message.Message;
import de.jiw.network.message.ServerInfoMessage;
import de.jiw.network.message.ServerPingMessage;
import de.jiw.network.serializing.BooleanArraySerializer;
import de.jiw.network.serializing.BooleanSerializer;
import de.jiw.network.serializing.ByteArraySerializer;
import de.jiw.network.serializing.ByteSerializer;
import de.jiw.network.serializing.ChannelReconnectSerializer;
import de.jiw.network.serializing.ClientRegisterChannelSerializer;
import de.jiw.network.serializing.ClientRegisterCompletedSerializer;
import de.jiw.network.serializing.ClientRegisterSerializer;
import de.jiw.network.serializing.DoubleArraySerializer;
import de.jiw.network.serializing.DoubleSerializer;
import de.jiw.network.serializing.FieldSerializer;
import de.jiw.network.serializing.FloatArraySerializer;
import de.jiw.network.serializing.FloatSerializer;
import de.jiw.network.serializing.IntArraySerializer;
import de.jiw.network.serializing.IntSerializer;
import de.jiw.network.serializing.LongArraySerializer;
import de.jiw.network.serializing.LongSerializer;
import de.jiw.network.serializing.ServerInfoSerializer;
import de.jiw.network.serializing.ServerPingSerializer;
import de.jiw.network.serializing.ShortArraySerializer;
import de.jiw.network.serializing.ShortSerializer;
import de.jiw.network.serializing.StringSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public abstract class Serializer {
    private static short classId = (short)16383;
    private static final HashMap<Class, Serializer> serializerMap = new HashMap();
    private static final HashMap<Short, Class> idToClassMap = new HashMap();
    private static final HashMap<Class, Short> classToIdMap = new HashMap();
    protected static final FieldSerializer defaultSerializer = new FieldSerializer();

    public static void registerClass(Class c) {
        Serializer.registerClass(c, defaultSerializer);
    }

    public static void registerClass(Class c, Serializer serializer) {
        short s = classId;
        classId = (short)(s + 1);
        Serializer.registerClass(s, c, serializer);
        if (Message.class.isAssignableFrom(c)) {
            for (Class<?> innerclass : c.getDeclaredClasses()) {
                short s2 = classId;
                classId = (short)(s2 + 1);
                Serializer.registerClass(s2, innerclass, serializer);
            }
        }
    }

    public static void registerClass(short id, Class c) {
        Serializer.registerClass(id, c, defaultSerializer);
    }

    public static void registerClass(short id, Class c, Serializer serializer) {
        if (classToIdMap.containsKey(c)) {
            throw new IllegalStateException("Class " + c.getName() + " already registered to serializer!");
        }
        idToClassMap.put(id, c);
        classToIdMap.put(c, id);
        serializerMap.put(c, serializer);
        serializer.initialize(c);
    }

    public static Serializer getSerializer(Class c) {
        return serializerMap.get(c);
    }

    public static Message read(ByteBuffer buffer) throws IOException, IllegalStateException {
        short id = buffer.getShort();
        Class c = idToClassMap.get(id);
        if (c == null) {
            throw new IllegalStateException("Class not found (" + id + ")");
        }
        Serializer serializer = serializerMap.get(c);
        if (serializer == null) {
            throw new IllegalStateException("No serializer found for class " + c.getName() + " (" + id + ")");
        }
        try {
            return (Message)serializer.readObject(buffer, c);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("SERIALIZER READ EXCEPTION: " + c.getName() + "  " + buffer.capacity());
            return null;
        }
    }

    public static void write(ByteBuffer buffer, Message message) throws IOException, IllegalStateException {
        Class<?> c = message.getClass();
        Serializer serializer = serializerMap.get(c);
        if (serializer == null) {
            throw new IllegalStateException("No serializer found for class " + c.getName());
        }
        buffer.putShort(classToIdMap.get(c));
        serializer.writeObject(buffer, message);
    }

    public static Message getClone(Message message) {
        Class<?> c = message.getClass();
        Serializer serializer = serializerMap.get(c);
        if (serializer == null) {
            throw new IllegalStateException("No serializer found for class " + c.getName());
        }
        return (Message)serializer.clone(message);
    }

    protected void initialize(Class c) {
    }

    public abstract <T> T readObject(ByteBuffer var1, Class<T> var2) throws IOException;

    public abstract void writeObject(ByteBuffer var1, Object var2) throws IOException;

    public abstract <T> T clone(Object var1);

    static {
        Serializer.registerClass(Byte.TYPE, new ByteSerializer());
        Serializer.registerClass(Boolean.TYPE, new BooleanSerializer());
        Serializer.registerClass(Short.TYPE, new ShortSerializer());
        Serializer.registerClass(Integer.TYPE, new IntSerializer());
        Serializer.registerClass(Float.TYPE, new FloatSerializer());
        Serializer.registerClass(Long.TYPE, new LongSerializer());
        Serializer.registerClass(Double.TYPE, new DoubleSerializer());
        Serializer.registerClass(byte[].class, new ByteArraySerializer());
        Serializer.registerClass(boolean[].class, new BooleanArraySerializer());
        Serializer.registerClass(short[].class, new ShortArraySerializer());
        Serializer.registerClass(int[].class, new IntArraySerializer());
        Serializer.registerClass(float[].class, new FloatArraySerializer());
        Serializer.registerClass(long[].class, new LongArraySerializer());
        Serializer.registerClass(double[].class, new DoubleArraySerializer());
        Serializer.registerClass(Byte.class, serializerMap.get(Byte.TYPE));
        Serializer.registerClass(Boolean.class, serializerMap.get(Boolean.TYPE));
        Serializer.registerClass(Short.class, serializerMap.get(Short.TYPE));
        Serializer.registerClass(Integer.class, serializerMap.get(Integer.TYPE));
        Serializer.registerClass(Float.class, serializerMap.get(Float.TYPE));
        Serializer.registerClass(Long.class, serializerMap.get(Long.TYPE));
        Serializer.registerClass(Double.class, serializerMap.get(Double.TYPE));
        Serializer.registerClass(String.class, new StringSerializer());
        Serializer.registerClass(DisconnectMessage.class);
        Serializer.registerClass(ChannelReconnectMessage.class, new ChannelReconnectSerializer());
        Serializer.registerClass(ClientRegisterMessage.class, new ClientRegisterSerializer());
        Serializer.registerClass(ClientRegisterCompletedMessage.class, new ClientRegisterCompletedSerializer());
        Serializer.registerClass(ClientRegisterChannelMessage.class, new ClientRegisterChannelSerializer());
        Serializer.registerClass(ServerInfoMessage.class, new ServerInfoSerializer());
        Serializer.registerClass(ServerPingMessage.class, new ServerPingSerializer());
    }
}

