/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;

public class FieldSerializer
extends Serializer {
    private static final ConcurrentHashMap<Class, MessageField[]> messageFieldMap = new ConcurrentHashMap();

    @Override
    protected void initialize(Class c) {
        if (!messageFieldMap.containsKey(c)) {
            Field[] fields = c.getFields();
            MessageField[] messageFields = new MessageField[fields.length];
            int f = 0;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int mod = field.getModifiers();
                if (Modifier.isTransient(mod) || Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                Class<?> type = field.getType();
                Serializer serializer = Serializer.getSerializer(type);
                if (serializer == null) {
                    throw new NullPointerException("No serializer found for " + type.getName());
                }
                MessageField mf = new MessageField(field, serializer);
                messageFields[f++] = mf;
            }
            if (f < fields.length) {
                MessageField[] newMessageFields = new MessageField[f];
                System.arraycopy(messageFields, 0, newMessageFields, 0, f);
                messageFieldMap.put(c, newMessageFields);
            } else {
                messageFieldMap.put(c, messageFields);
            }
        }
    }

    @Override
    public <T> T readObject(ByteBuffer data, Class<T> c) throws IOException {
        try {
            T message = c.newInstance();
            for (MessageField field : messageFieldMap.get(c)) {
                field.field.set(message, field.serializer.readObject(data, field.field.getType()));
            }
            return message;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        for (MessageField field : messageFieldMap.get(object.getClass())) {
            try {
                field.serializer.writeObject(buffer, field.field.get(object));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T> T clone(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Object clone = object.getClass().newInstance();
            for (MessageField field : messageFieldMap.get(object.getClass())) {
                try {
                    field.field.set(clone, field.serializer.clone(field.field.get(object)));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return (T)clone;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final class MessageField {
        public Field field;
        public Serializer serializer;

        public MessageField(Field field, Serializer serializer) {
            this.field = field;
            this.serializer = serializer;
        }
    }
}

