/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteArraySerializer
extends Serializer {
    public byte[] readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len == -1) {
            return null;
        }
        byte[] array = new byte[len &= 0xFFFF];
        for (int i = 0; i < len; ++i) {
            array[i] = data.get();
        }
        return array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        byte[] array = (byte[])object;
        if (array.length > 65534) {
            throw new UnsupportedOperationException("Array length too large for FieldSerializer: " + array.length);
        }
        buffer.putShort((short)array.length);
        buffer.put(array);
    }

    public byte[] clone(Object object) {
        if (object == null) {
            return null;
        }
        byte[] array = (byte[])object;
        byte[] clone = new byte[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }
}

