/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.serializing;

import de.jiw.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BooleanArraySerializer
extends Serializer {
    public boolean[] readObject(ByteBuffer data, Class c) throws IOException {
        int len = data.getShort();
        if (len == -1) {
            return null;
        }
        boolean[] array = new boolean[len &= 0xFFFF];
        for (int i = 0; i < len; ++i) {
            array[i] = data.get() == 1;
        }
        return array;
    }

    @Override
    public void writeObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        boolean[] array = (boolean[])object;
        if (array.length > 65534) {
            throw new UnsupportedOperationException("Array length too large for FieldSerializer: " + array.length);
        }
        buffer.putShort((short)array.length);
        for (int i = 0; i < array.length; ++i) {
            buffer.put(array[i] ? (byte)1 : 0);
        }
    }

    public boolean[] clone(Object object) {
        if (object == null) {
            return null;
        }
        boolean[] array = (boolean[])object;
        boolean[] clone = new boolean[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }
}

