/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.message;

import de.jiw.network.base.HostedConnection;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.message.Message;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RawPacket
implements Runnable {
    private Endpoint source;
    private boolean reliable;
    private final MessageProtocol protocol;

    public RawPacket(Endpoint source, byte[] data, boolean reliable) {
        this.source = source;
        this.reliable = reliable;
        this.protocol = source.getKernel().getAdapter().getMessageProtocol(source);
        this.protocol.addRawData(data);
    }

    public Endpoint getSource() {
        return this.source;
    }

    public boolean isReliable() {
        return this.reliable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageProtocol messageProtocol = this.protocol;
        synchronized (messageProtocol) {
            block7: {
                try {
                    Message m;
                    ByteBuffer buffer = ByteBuffer.wrap(this.protocol.getRawData());
                    this.protocol.addBuffer(buffer);
                    int count = this.protocol.addBuffer(buffer);
                    if (count == 0 && !this.reliable) {
                        Logger.getLogger(RawPacket.class.getName()).log(Level.WARNING, "RawPacket (UDP) contained incomplete data (EndpointID: {0})", this.source.getId());
                        return;
                    }
                    while ((m = this.protocol.getMessage()) != null) {
                        this.source.getKernel().getAdapter().dispatch(this.source, m);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.protocol.resetCurrent();
                    HostedConnection conn = this.source.getHostedConnection();
                    if (conn == null || ++conn.errorcounter <= 50) break block7;
                    this.source.getHostedConnection().closeConnection(true);
                }
            }
        }
    }
}

