/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.kernel.udp;

import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.Kernel;
import de.jiw.network.kernel.udp.UdpKernel;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpEndpoint
extends Endpoint {
    private UdpKernel kernel;
    protected ConcurrentLinkedQueue<ByteBuffer> outbound = new ConcurrentLinkedQueue();
    private boolean closeRequest = false;
    private boolean closed = false;
    private int endpointID = 0;
    private SocketAddress address;

    public UdpEndpoint(UdpKernel kernel, int endpointID, SocketAddress address, DatagramSocket socket) {
        this.kernel = kernel;
        this.endpointID = endpointID;
        this.address = address;
    }

    @Override
    public int getId() {
        return this.endpointID;
    }

    @Override
    public Kernel getKernel() {
        return this.kernel;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void terminate() {
    }

    @Override
    public void closeEndpoint() {
        if (this.kernel instanceof UdpKernel) {
            this.kernel.removeEndpoint(null);
        }
    }

    @Override
    public void close(boolean force) {
        try {
            this.kernel.cancel(this);
        }
        catch (Exception e) {
            Logger.getLogger(UdpEndpoint.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public boolean isCloseRequested() {
        return this.closeRequest;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed(boolean close) {
        this.closeRequest = true;
        this.closed = close;
    }

    @Override
    public void send(ByteBuffer data) {
        this.send(data, true);
    }

    @Override
    public void send(ByteBuffer data, boolean wakeup) {
        try {
            DatagramPacket packet = new DatagramPacket(data.array(), 0, data.array().length, this.address);
            this.kernel.write(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ByteBuffer peekPending() {
        return this.outbound.peek();
    }

    protected ByteBuffer removePending() {
        return this.outbound.poll();
    }

    protected boolean hasPending() {
        return !this.outbound.isEmpty();
    }

    @Override
    public SocketAddress getAddress() {
        return this.address;
    }
}

