/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.kernel;

import de.jiw.network.Network;
import de.jiw.network.base.Connection;
import de.jiw.network.kernel.Endpoint;
import de.jiw.network.kernel.KernelAdapter;
import de.jiw.network.message.RawPacket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Kernel
extends Thread {
    protected final int id;
    protected final InetSocketAddress address;
    private volatile long bytesSend = 0L;
    private volatile long bytesReceive = 0L;
    private volatile long packetsSend = 0L;
    private volatile long packetsReceive = 0L;
    private volatile Network.ChannelType type;
    protected AtomicBoolean active = new AtomicBoolean(false);
    private AtomicInteger idcounter_endpoints = new AtomicInteger();
    private LinkedBlockingQueue<RawPacket> rawPackets = new LinkedBlockingQueue();
    protected ConcurrentLinkedQueue<Endpoint> pendingCloseEvents = new ConcurrentLinkedQueue();
    protected KernelAdapter adapter;

    public Kernel(int id, InetSocketAddress address) {
        this.id = id;
        this.address = address;
    }

    public abstract void initialize() throws IOException;

    public abstract void terminate() throws IOException, InterruptedException;

    public boolean isActive() {
        return this.active.get();
    }

    protected int getNextEndpointId() {
        return this.idcounter_endpoints.getAndIncrement();
    }

    public int getKernelId() {
        return this.id;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public abstract void wakeupSelector();

    protected void addRawPacket(RawPacket rawPacket) throws IOException {
        if (!this.rawPackets.offer(rawPacket)) {
            throw new IOException("Cannot add RawPacket");
        }
    }

    public boolean hasRawPackets() {
        return !this.rawPackets.isEmpty();
    }

    public int getRawPacketsCount() {
        return this.rawPackets.size();
    }

    public RawPacket read() throws InterruptedException {
        return this.rawPackets.poll();
    }

    public void setAdapter(KernelAdapter adapter) {
        this.adapter = adapter;
    }

    public KernelAdapter getAdapter() {
        return this.adapter;
    }

    public long getPacketsReceive() {
        return this.packetsReceive;
    }

    public long getBytesReceive() {
        return this.bytesReceive;
    }

    public long getPacketsSend() {
        return this.packetsSend;
    }

    public long getBytesSend() {
        return this.bytesSend;
    }

    public void addBytesSend(int count) {
        this.bytesSend += (long)count;
    }

    public void addPacketsSend(int count) {
        this.packetsSend += (long)count;
    }

    public void addBytesReceive(int count) {
        this.bytesReceive += (long)count;
    }

    public void addPacketsReceive(int count) {
        this.packetsReceive += (long)count;
    }

    protected void setType(Network.ChannelType type) {
        this.type = type;
    }

    public Network.ChannelType getType() {
        return this.type;
    }

    public abstract void broadcast(Connection var1, ByteBuffer var2);
}

