/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.connector;

import de.jiw.network.connector.Connector;
import de.jiw.network.connector.ConnectorAdapter;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnectorWriteThread
extends Thread {
    private ConnectorAdapter adapter;
    private Connector connector;
    private AtomicBoolean active = new AtomicBoolean(false);
    private ByteBuffer wakeupBuffer = ByteBuffer.allocate(0);
    protected LinkedBlockingQueue<ByteBuffer> sendPending = new LinkedBlockingQueue();

    public ConnectorWriteThread(ConnectorAdapter adapter, Connector connector) {
        this.adapter = adapter;
        this.connector = connector;
        this.setDaemon(true);
        this.setName("ConnectorWriteThread Type:" + adapter.getType().name() + " Port:" + adapter.getPort());
    }

    public void open() {
        this.active.set(true);
        this.start();
    }

    public void close() {
        this.active.set(false);
        this.sendPending.clear();
        this.sendPending.add(this.wakeupBuffer);
    }

    @Override
    public void run() {
        while (this.active.get()) {
            try {
                ByteBuffer buffer = this.sendPending.take();
                if (buffer == null || buffer.capacity() == 0) continue;
                this.connector.write(buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

