/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network.connector;

import de.jiw.network.Network;
import de.jiw.network.NetworkClient;
import de.jiw.network.base.MessageProtocol;
import de.jiw.network.connector.Connector;
import de.jiw.network.connector.ConnectorReadThread;
import de.jiw.network.connector.ConnectorWriteThread;
import de.jiw.network.message.ClientRegisterChannelMessage;
import de.jiw.network.message.ClientRegisterMessage;
import de.jiw.network.message.Message;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnectorAdapter {
    private ConnectorReadThread readThread;
    private ConnectorWriteThread writeThread;
    private Connector connector;
    private NetworkClient client;
    private Network.ChannelType type;
    private boolean reliable = false;
    private int channelId;
    private int port;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private volatile long bytesSend = 0L;
    private volatile long bytesReceive = 0L;
    private volatile long packetsSend = 0L;
    private volatile long packetsReceive = 0L;

    public ConnectorAdapter(NetworkClient client, Connector connector, Network.ChannelType type, int channelId, int port) {
        this.type = type;
        this.connector = connector;
        this.connector.setAdapter(this);
        this.channelId = channelId;
        this.port = port;
        this.client = client;
        if (type == Network.ChannelType.TCP) {
            this.reliable = true;
        }
        this.readThread = new ConnectorReadThread(this, connector);
        this.writeThread = new ConnectorWriteThread(this, connector);
    }

    public long getBytesReceive() {
        return this.bytesReceive;
    }

    public long getPacketsReceive() {
        return this.packetsReceive;
    }

    public long getBytesSend() {
        return this.bytesSend;
    }

    public long getPacketsSend() {
        return this.packetsSend;
    }

    public boolean start() {
        if (!this.connector.start(this.client.getAddress(), this.port)) {
            return false;
        }
        try {
            if (this.channelId == 0) {
                ClientRegisterMessage registerMessage = new ClientRegisterMessage();
                registerMessage.version = this.client.getVersion();
                ByteBuffer buffer = MessageProtocol.messageToBuffer(registerMessage, Network.sharedBuffer.get());
                this.bytesSend += (long)buffer.capacity();
                ++this.packetsSend;
                this.connector.write(buffer);
            } else if (this.reliable) {
                System.out.println("SEND ClientRegisterChannelMessage");
                ClientRegisterChannelMessage registerChannel = new ClientRegisterChannelMessage();
                registerChannel.id = this.client.getId();
                ByteBuffer buffer = MessageProtocol.messageToBuffer(registerChannel, Network.sharedBuffer.get());
                this.bytesSend += (long)buffer.capacity();
                ++this.packetsSend;
                this.connector.write(buffer);
            }
            this.readThread.open();
            this.writeThread.open();
            this.isRunning.set(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean isReliable() {
        return this.reliable;
    }

    public boolean isConnected() {
        return this.isRunning.get() && this.connector.isConnected();
    }

    public int getId() {
        return this.channelId;
    }

    public Network.ChannelType getType() {
        return this.type;
    }

    public void send(Message m) {
        try {
            ByteBuffer buffer = MessageProtocol.messageToBuffer(m, Network.sharedBuffer.get());
            this.bytesSend += (long)buffer.capacity();
            ++this.packetsSend;
            this.writeThread.sendPending.add(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (!this.isRunning.get()) {
            return;
        }
        this.isRunning.set(false);
        this.writeThread.close();
        this.readThread.close();
        this.connector.close();
    }

    public void connectorClose(Exception exception) {
        if (exception != null) {
            this.client.onConnectorError(exception);
        } else {
            this.client.onConnectorDisconnect();
        }
    }

    public void connectorTimeout() {
        this.client.connectorTimeout();
    }

    public int getPort() {
        return this.port;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public NetworkClient getClient() {
        return this.client;
    }

    public void dispatch(int size, Message m) {
        ++this.packetsReceive;
        this.bytesReceive += (long)size;
        if (m.getClass() == ClientRegisterChannelMessage.class) {
            ClientRegisterChannelMessage msg = (ClientRegisterChannelMessage)m;
            if (msg.id != this.client.getId()) {
                throw new Error("RegisterChannel Error Server returned wrong ID Port:" + this.connector.getPort());
            }
            if (this.reliable) {
                this.client.onTcpConnectorConnect(this);
            } else {
                this.client.onUdpConnectorConnect(this);
            }
            return;
        }
        this.client.dispatch(m);
    }
}

