/*
 * Decompiled with CFR 0.152.
 */
package de.jiw.network;

import de.jiw.network.Client;
import de.jiw.network.Network;
import de.jiw.network.connector.ConnectorAdapter;
import de.jiw.network.connector.tcp.TcpConnector;
import de.jiw.network.connector.udp.UdpConnector;
import de.jiw.network.listener.ClientStateListener;
import de.jiw.network.listener.MessageListener;
import de.jiw.network.message.ClientRegisterChannelMessage;
import de.jiw.network.message.ClientRegisterCompletedMessage;
import de.jiw.network.message.DisconnectMessage;
import de.jiw.network.message.Message;
import de.jiw.network.message.ServerInfoMessage;
import de.jiw.network.message.ServerPingMessage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkClient
implements Client {
    private int clientServerId;
    private String serverUUID;
    private InetAddress address;
    private String host;
    private int port;
    private String version;
    private AtomicBoolean hasServerInformation = new AtomicBoolean(false);
    private AtomicInteger channelCount = new AtomicInteger();
    private ConcurrentHashMap<Integer, ConnectorAdapter> channels = new ConcurrentHashMap();
    private CopyOnWriteArrayList<ClientStateListener> clientStateListeners = new CopyOnWriteArrayList();
    private ConcurrentHashMap<Class<? extends Message>, MessageListener> listenerMappings = new ConcurrentHashMap();
    private AtomicBoolean connected = new AtomicBoolean(false);
    private ConcurrentHashMap<Integer, ConnectorAdapter> pendingTcpAdapters = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ConnectorAdapter> pendingUdpAdapters = new ConcurrentHashMap();
    private short pingClientServer = 0;
    private short pingServerClient = 0;
    private short ping = 0;
    public int errorcounter = 0;
    private ConcurrentHashMap<Integer, ConnectorAdapter> reconnectingAdapters = new ConcurrentHashMap();
    private ConnectorAdapter defaultTcpAdapter = null;
    private int udpTimeout = 0;
    private UdpCheckThread udpCheckThread;

    public NetworkClient(String version) {
        System.out.println("NetworkClient version 0.6");
        this.version = version;
    }

    public boolean connectToServer(String host, int port) throws UnknownHostException {
        return this.connectToServer(InetAddress.getByName(host), port);
    }

    @Override
    public synchronized boolean connectToServer(InetAddress address, int port) {
        this.reset();
        this.host = address.getHostAddress();
        this.address = address;
        this.port = port;
        ConnectorAdapter tcpAdapter = this.addChannel(0, port, Network.ChannelType.TCP);
        if (!tcpAdapter.start()) {
            this.onClientConnectError();
            return false;
        }
        if (tcpAdapter.isConnected()) {
            this.channels.put(tcpAdapter.getId(), tcpAdapter);
        }
        return true;
    }

    public void closeConnector(int id) {
        this.channels.get(id).getConnector().close();
    }

    public void setReconnectingAdapter(ConnectorAdapter adapter, boolean set) {
        if (set) {
            this.reconnectingAdapters.put(adapter.getId(), adapter);
        } else {
            this.reconnectingAdapters.remove(adapter.getId());
        }
    }

    public boolean isAdapterReconnecting(int id) {
        return this.reconnectingAdapters.get(id) != null;
    }

    @Override
    public void disconnect(boolean force) {
        if (!force) {
            this.send(new DisconnectMessage());
            Thread timer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        NetworkClient.this.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            timer.setDaemon(true);
        } else {
            for (ConnectorAdapter adapter : this.channels.values()) {
                adapter.stop();
            }
            for (ClientStateListener listener : this.clientStateListeners) {
                listener.onClientDisconnect(this);
            }
        }
    }

    @Override
    public void reset() {
        this.connected.set(false);
        for (ConnectorAdapter adapter : this.channels.values()) {
            adapter.stop();
        }
        for (ConnectorAdapter adapter : this.pendingTcpAdapters.values()) {
            adapter.stop();
        }
        for (ConnectorAdapter adapter : this.pendingUdpAdapters.values()) {
            adapter.stop();
        }
        this.channels.clear();
        this.channelCount.set(0);
        this.pendingTcpAdapters.clear();
        this.pendingUdpAdapters.clear();
        this.hasServerInformation.set(false);
        this.udpTimeout = 0;
        this.clientServerId = 0;
        this.errorcounter = 0;
        this.defaultTcpAdapter = null;
        if (this.udpCheckThread != null) {
            this.udpCheckThread.isActive = false;
            this.udpCheckThread = null;
        }
    }

    @Override
    public void addClientStateListener(ClientStateListener listener) {
        this.clientStateListeners.add(listener);
    }

    @Override
    public void addMessageListener(MessageListener listener, Class<? extends Message> message) {
        this.listenerMappings.put(message, listener);
    }

    public synchronized void onTcpConnectorConnect(ConnectorAdapter adapter) {
        this.pendingTcpAdapters.remove(adapter.getId());
        this.channels.put(adapter.getId(), adapter);
        System.out.println("onConnectorConnect: " + adapter.getType().name() + " Port: " + adapter.getPort());
        System.out.println("onConnectorConnect channels.size: " + this.channels.size() + " channelCount: " + this.channelCount.get());
        if (this.pendingTcpAdapters.isEmpty() && this.udpCheckThread == null) {
            System.out.println("Client TCP Connect Completed");
            this.udpCheckThread = new UdpCheckThread();
            this.udpCheckThread.isActive = true;
            this.udpCheckThread.start();
        }
    }

    public synchronized void onUdpConnectorConnect(ConnectorAdapter adapter) {
        System.out.println("onUdpConnectorConnect " + adapter.getPort());
        this.pendingUdpAdapters.remove(adapter.getId());
        this.channels.put(adapter.getId(), adapter);
        if (this.pendingUdpAdapters.isEmpty()) {
            this.udpCheckThread.isActive = false;
            this.udpCheckThread = null;
            this.channels.get(0).send(new ClientRegisterCompletedMessage(this.clientServerId));
            this.connected.set(true);
            for (Integer i : this.channels.keySet()) {
                ConnectorAdapter a = this.channels.get(i);
                System.out.println("ConnectorAdapter ID: " + i + "  " + (Object)((Object)a.getType()) + " " + a.getPort());
            }
            for (ClientStateListener listener : this.clientStateListeners) {
                listener.onClientConnect(this);
            }
        }
    }

    public synchronized void onConnectorError(Exception exception) {
        if (!this.connected.get()) {
            return;
        }
        exception.printStackTrace();
        this.connected.set(false);
        this.close();
        if (this.channels.isEmpty()) {
            for (ClientStateListener listener : this.clientStateListeners) {
                listener.onClientError(this, exception);
            }
        }
    }

    public synchronized void onConnectorDisconnect() {
        if (!this.connected.get()) {
            return;
        }
        this.connected.set(false);
        this.close();
        for (ClientStateListener listener : this.clientStateListeners) {
            listener.onClientDisconnect(this);
        }
    }

    @Override
    public synchronized void connectorTimeout() {
        for (ClientStateListener listener : this.clientStateListeners) {
            listener.onClientTimeout(this);
        }
    }

    public void onConnectorReconnect(int id) {
        for (ClientStateListener listener : this.clientStateListeners) {
            listener.onClientLosingConnection(this, id);
        }
    }

    protected synchronized void close() {
        System.out.println("CLOSE");
        for (ConnectorAdapter a : this.channels.values()) {
            a.stop();
        }
        this.channels.clear();
        this.reset();
    }

    @Override
    public void send(Message m) {
        this.send(0, m);
    }

    @Override
    public void send(int channel, Message m) {
        if (this.connected.get()) {
            ConnectorAdapter adapter = this.channels.get(channel);
            if (adapter == null) {
                throw new Error("Channel " + channel + " not connected.");
            }
            adapter.send(m);
        } else {
            System.out.println("Client send: Client not connected!");
        }
    }

    public void broadcast(Message m) {
        for (ConnectorAdapter adapter : this.channels.values()) {
            adapter.send(m);
        }
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    public void dispatch(Message m) {
        Class<?> mClass = m.getClass();
        if (mClass == DisconnectMessage.class) {
            DisconnectMessage msg = (DisconnectMessage)m;
            this.disconnect(true);
            for (ClientStateListener listener : this.clientStateListeners) {
                listener.onClientKick(this, msg.reason);
            }
        } else if (mClass == ServerInfoMessage.class) {
            int i;
            ServerInfoMessage msg = (ServerInfoMessage)m;
            this.clientServerId = msg.id;
            this.serverUUID = msg.uuid;
            if (msg.tcpPorts.length == 0 && msg.udpPorts.length == 0) {
                this.connected.set(true);
                for (ClientStateListener listener : this.clientStateListeners) {
                    listener.onClientConnect(this);
                }
                return;
            }
            ConnectorAdapter adapter = this.addChannel(1, this.port, Network.ChannelType.UDP);
            System.out.println(Arrays.toString(msg.tcpPorts));
            for (i = 0; i < msg.tcpPorts.length; i += 2) {
                this.addChannel(msg.tcpPorts[i], msg.tcpPorts[i + 1], Network.ChannelType.TCP);
            }
            for (i = 0; i < msg.udpPorts.length; i += 2) {
                this.addChannel(msg.udpPorts[i], msg.udpPorts[i + 1], Network.ChannelType.UDP);
            }
            for (ConnectorAdapter a : this.pendingTcpAdapters.values()) {
                if (a.start()) continue;
                this.onClientConnectError();
                return;
            }
            for (ConnectorAdapter a : this.pendingUdpAdapters.values()) {
                if (a.start()) continue;
                this.onClientConnectError();
                return;
            }
            this.hasServerInformation.set(true);
        } else if (mClass == ServerPingMessage.class) {
            if (!this.connected.get()) {
                return;
            }
            ServerPingMessage msg = (ServerPingMessage)m;
            msg.clientSendTime = System.currentTimeMillis();
            this.send(1, msg);
            this.pingClientServer = msg.oldClientServerPing;
            this.pingServerClient = msg.oldServerClientPing;
            this.ping = msg.oldPing;
        } else {
            this.listenerMappings.get(mClass).messageReceived(this, m);
        }
    }

    private ConnectorAdapter addChannel(int id, int port, Network.ChannelType type) {
        ConnectorAdapter adapter;
        if (this.connected.get()) {
            throw new Error("Add Channel not allowed after connect");
        }
        if (type == Network.ChannelType.TCP) {
            adapter = new ConnectorAdapter(this, new TcpConnector(), type, id, port);
            if (adapter.getId() != 0) {
                this.pendingTcpAdapters.put(adapter.getId(), adapter);
            } else {
                this.defaultTcpAdapter = adapter;
            }
        } else {
            adapter = new ConnectorAdapter(this, new UdpConnector(), type, id, port);
            this.pendingUdpAdapters.put(adapter.getId(), adapter);
        }
        return adapter;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUUID() {
        return this.serverUUID;
    }

    private void onClientConnectError() {
        this.connected.set(false);
        for (ConnectorAdapter adapter : this.channels.values()) {
            adapter.stop();
        }
        this.channels.clear();
        for (ClientStateListener listener : this.clientStateListeners) {
            listener.onClientConnectError(this);
        }
    }

    public long getPacketsReceive() {
        long temp = 0L;
        for (ConnectorAdapter adapter : this.channels.values()) {
            temp += adapter.getPacketsReceive();
        }
        return temp;
    }

    public long getBytesReceive() {
        long temp = 0L;
        for (ConnectorAdapter adapter : this.channels.values()) {
            temp += adapter.getBytesReceive();
        }
        return temp;
    }

    public long getPacketsSend() {
        long temp = 0L;
        for (ConnectorAdapter adapter : this.channels.values()) {
            temp += adapter.getPacketsSend();
        }
        return temp;
    }

    public long getBytesSend() {
        long temp = 0L;
        for (ConnectorAdapter adapter : this.channels.values()) {
            temp += adapter.getBytesSend();
        }
        return temp;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public int getId() {
        return this.clientServerId;
    }

    public short getPing() {
        return this.ping;
    }

    public short getClientServerPing() {
        return this.pingClientServer;
    }

    public short getServerClientPing() {
        return this.pingServerClient;
    }

    public void stopChannel(int id) {
        this.channels.get(id).stop();
    }

    public void reconnect() {
        for (ConnectorAdapter adapter : this.channels.values()) {
            if (adapter.getType() != Network.ChannelType.UDP) continue;
            ((UdpConnector)adapter.getConnector()).reconnect();
        }
    }

    private class UdpCheckThread
    extends Thread {
        public int timeout = 7500;
        public boolean isActive = false;

        public UdpCheckThread() {
            this.setDaemon(true);
            this.setName("UdpCheckThread");
        }

        @Override
        public void run() {
            while (this.isActive) {
                try {
                    ClientRegisterChannelMessage cm = new ClientRegisterChannelMessage(1, NetworkClient.this.clientServerId);
                    for (ConnectorAdapter adapter : NetworkClient.this.pendingUdpAdapters.values()) {
                        adapter.send(cm);
                    }
                    Thread.sleep(300L);
                    NetworkClient.this.udpTimeout = NetworkClient.this.udpTimeout + 300;
                    if (NetworkClient.this.udpTimeout <= this.timeout) continue;
                    this.isActive = false;
                    NetworkClient.this.onClientConnectError();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

