
# ChestDoorLockPlugin

Per-chest & per-door permissions for Rising World (new Plugin API).

## Build

1) Place the Rising World API jar in `libs/` and name it `rising-world-api.jar` (or update `build.gradle`).
2) Build with Gradle (Java 17+):
   ```bash
   gradle clean jar
   ```
3) Copy the built JAR from `build/libs/ChestDoorLockPlugin-0.1.0.jar` to your server's `Plugins/` folder.

## Commands

- `/lock set` — lock the chest/door you're looking at (owner = you).
- `/lock allow <player>` — add player to allow-list (online player lookup).
- `/lock deny <player>` — remove player from allow-list.
- `/lock public on|off` — toggle public access (anyone can use).
- `/lock info` — show owner/public for the looked-at target.
- `/lock remove` — remove lock (owner/admin).

## Notes

- Uses a local SQLite DB in the plugin data path (`lockdb.db`).
- Guards both container open and door status changes via cancellable events.
- You can extend with claim integration and offline UID allow-list support.
