/*
 * Decompiled with CFR 0.152.
 */
package mobspawner;

import java.util.Map;
import mobspawner.MobSpawner;
import mobspawner.Spawner;
import mobspawner.SpawnerBuilder;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UIScrollView;
import net.risingworld.api.ui.style.Font;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.TextAnchor;

public class SpawnerUI {
    MobSpawner mobSpawner;
    Player player;
    UIElement spawnerUI;
    UIScrollView spawnScroll;
    public SpawnerUI spawnUI;
    UILabel killMob;

    public SpawnerUI(MobSpawner mobSpawner, Player player) {
        this.mobSpawner = mobSpawner;
        this.player = player;
        this.spawnUI = this;
        player.setMouseCursorVisible(true);
        this.spawnerUI();
    }

    private void spawnerUI() {
        this.spawnerUI = new UIElement();
        this.spawnerUI.setSize(25.0f, 75.0f, true);
        this.spawnerUI.setPosition(50.0f, 50.0f, true);
        this.spawnerUI.setPivot(Pivot.MiddleCenter);
        this.spawnerUI.setVisible(true);
        this.spawnerUI.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.75f);
        this.spawnerUI.setBorder(2.0f);
        this.spawnerUI.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.spawnerUI.setBorderEdgeRadius(10.0f, false);
        this.spawnerUI.style.backgroundImage.set(this.mobSpawner.mobSpawnerSettings.background);
        UILabel mobLabel = new UILabel("Mob Menu");
        mobLabel.setPivot(Pivot.MiddleCenter);
        mobLabel.setSize(5.0f, 5.0f, true);
        mobLabel.setPosition(50.0f, 5.0f, true);
        mobLabel.setFont(Font.Default);
        mobLabel.setFontSize(30.0f);
        this.spawnScroll = new UIScrollView(UIScrollView.ScrollViewMode.Vertical);
        this.spawnScroll.setPivot(Pivot.MiddleCenter);
        this.spawnScroll.setSize(90.0f, 55.0f, true);
        this.spawnScroll.setPosition(50.0f, 60.0f, true);
        this.spawnScroll.style.paddingTop.set(5.0f);
        this.spawnScroll.style.paddingBottom.set(5.0f);
        this.spawnScroll.setPivot(Pivot.MiddleCenter);
        this.spawnScroll.setBorder(2.0f);
        this.spawnScroll.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.75f);
        this.spawnScroll.setBorderEdgeRadius(10.0f, false);
        this.spawnScroll.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.spawnScroll.setVisible(true);
        this.spawnerUI.addChild((UIElement)mobLabel);
        this.spawnerUI.addChild((UIElement)this.spawnScroll);
        this.closeButton();
        this.refreshButton();
        this.destroyAllButton();
        this.spawnBanditButton();
        this.spawnBarbarianButton();
        this.spawnSkeletonButton();
        this.spawnGhoulButton();
        this.finish();
    }

    private void closeButton() {
        UILabel closeButton = new UILabel("Close"){

            public void onClick(PlayerUIElementClickEvent event) {
                SpawnerUI.this.player.removeUIElement(SpawnerUI.this.spawnerUI);
                SpawnerUI.this.player.setMouseCursorVisible(false);
            }
        };
        closeButton.setBorderEdgeRadius(10.0f, false);
        closeButton.setBorder(2.0f);
        closeButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        closeButton.setPivot(Pivot.MiddleCenter);
        closeButton.setClickable(true);
        closeButton.setVisible(true);
        closeButton.setSize(20.0f, 5.0f, true);
        closeButton.setPosition(25.0f, 95.0f, true);
        closeButton.setBackgroundColor(1.0f, 0.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)closeButton);
    }

    private void refreshButton() {
        UILabel refreshButton = new UILabel("Refresh"){

            public void onClick(PlayerUIElementClickEvent event) {
                SpawnerUI.this.refresh();
            }
        };
        refreshButton.setBorderEdgeRadius(10.0f, false);
        refreshButton.setBorder(2.0f);
        refreshButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        refreshButton.setPivot(Pivot.MiddleCenter);
        refreshButton.setClickable(true);
        refreshButton.setVisible(true);
        refreshButton.setSize(20.0f, 5.0f, true);
        refreshButton.setPosition(50.0f, 95.0f, true);
        refreshButton.setBackgroundColor(0.0f, 1.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)refreshButton);
    }

    private void destroyAllButton() {
        UILabel destroyAllButton = new UILabel("Destroy Mobs"){

            public void onClick(PlayerUIElementClickEvent event) {
                if (SpawnerUI.this.mobSpawner.spawnerList.isEmpty()) {
                    event.getPlayer().showStatusMessage("No Mobs to Destroy", 5);
                } else {
                    for (Map.Entry<Integer, Spawner> entry : SpawnerUI.this.mobSpawner.spawnerList.entrySet()) {
                        entry.getValue().killMob(SpawnerUI.this.spawnUI, event.getPlayer());
                    }
                }
            }
        };
        destroyAllButton.setBorderEdgeRadius(10.0f, false);
        destroyAllButton.setBorder(2.0f);
        destroyAllButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        destroyAllButton.setPivot(Pivot.MiddleCenter);
        destroyAllButton.setClickable(true);
        destroyAllButton.setVisible(true);
        destroyAllButton.setSize(20.0f, 5.0f, true);
        destroyAllButton.setPosition(75.0f, 95.0f, true);
        destroyAllButton.setBackgroundColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)destroyAllButton);
    }

    private void spawnBanditButton() {
        UILabel banditButton = new UILabel("Bandits"){

            public void onClick(PlayerUIElementClickEvent event) {
                new SpawnerBuilder(SpawnerUI.this.mobSpawner, "Bandit", SpawnerUI.this.player);
                SpawnerUI.this.refresh();
            }
        };
        banditButton.setBorderEdgeRadius(10.0f, false);
        banditButton.setBorder(2.0f);
        banditButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        banditButton.setPivot(Pivot.MiddleCenter);
        banditButton.setClickable(true);
        banditButton.setVisible(true);
        banditButton.setSize(25.0f, 5.0f, true);
        banditButton.setPosition(25.0f, 15.0f, true);
        banditButton.setBackgroundColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)banditButton);
    }

    private void spawnBarbarianButton() {
        UILabel barbarianButton = new UILabel("Barbarians"){

            public void onClick(PlayerUIElementClickEvent event) {
                new SpawnerBuilder(SpawnerUI.this.mobSpawner, "Barbarian", SpawnerUI.this.player);
                SpawnerUI.this.refresh();
            }
        };
        barbarianButton.setBorderEdgeRadius(10.0f, false);
        barbarianButton.setBorder(2.0f);
        barbarianButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        barbarianButton.setPivot(Pivot.MiddleCenter);
        barbarianButton.setClickable(true);
        barbarianButton.setVisible(true);
        barbarianButton.setSize(25.0f, 5.0f, true);
        barbarianButton.setPosition(75.0f, 15.0f, true);
        barbarianButton.setBackgroundColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)barbarianButton);
    }

    private void spawnSkeletonButton() {
        UILabel skeletonButton = new UILabel("Skeletons"){

            public void onClick(PlayerUIElementClickEvent event) {
                new SpawnerBuilder(SpawnerUI.this.mobSpawner, "Skeleton", SpawnerUI.this.player);
                SpawnerUI.this.refresh();
            }
        };
        skeletonButton.setBorderEdgeRadius(10.0f, false);
        skeletonButton.setBorder(2.0f);
        skeletonButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        skeletonButton.setPivot(Pivot.MiddleCenter);
        skeletonButton.setClickable(true);
        skeletonButton.setVisible(true);
        skeletonButton.setSize(25.0f, 5.0f, true);
        skeletonButton.setPosition(25.0f, 25.0f, true);
        skeletonButton.setBackgroundColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)skeletonButton);
    }

    private void spawnGhoulButton() {
        UILabel ghoulButton = new UILabel("Ghouls"){

            public void onClick(PlayerUIElementClickEvent event) {
                new SpawnerBuilder(SpawnerUI.this.mobSpawner, "Ghoul", SpawnerUI.this.player);
                SpawnerUI.this.refresh();
            }
        };
        ghoulButton.setBorderEdgeRadius(10.0f, false);
        ghoulButton.setBorder(2.0f);
        ghoulButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        ghoulButton.setPivot(Pivot.MiddleCenter);
        ghoulButton.setClickable(true);
        ghoulButton.setVisible(true);
        ghoulButton.setSize(25.0f, 5.0f, true);
        ghoulButton.setPosition(75.0f, 25.0f, true);
        ghoulButton.setBackgroundColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)ghoulButton);
    }

    private void spawnMixedButton() {
        UILabel mixedButton = new UILabel("Mixed"){

            public void onClick(PlayerUIElementClickEvent event) {
                new SpawnerBuilder(SpawnerUI.this.mobSpawner, "Mixed", SpawnerUI.this.player);
                SpawnerUI.this.refresh();
            }
        };
        mixedButton.setBorderEdgeRadius(10.0f, false);
        mixedButton.setBorder(2.0f);
        mixedButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        mixedButton.setPivot(Pivot.MiddleCenter);
        mixedButton.setClickable(true);
        mixedButton.setVisible(true);
        mixedButton.setSize(25.0f, 5.0f, true);
        mixedButton.setPosition(50.0f, 35.0f, true);
        mixedButton.setBackgroundColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.spawnerUI.addChild((UIElement)mixedButton);
    }

    private void finish() {
        this.buildMobListings();
        this.player.addUIElement(this.spawnerUI);
    }

    public void refresh() {
        this.spawnScroll.removeAllChilds();
        this.buildMobListings();
    }

    private void buildMobListings() {
        if (this.mobSpawner.spawnerList.isEmpty()) {
            UILabel noMobs = new UILabel("No Mobs To Load");
            noMobs.setPosition(50.0f, 50.0f, true);
            noMobs.setTextAlign(TextAnchor.MiddleCenter);
            noMobs.setPivot(Pivot.UpperCenter);
            this.spawnScroll.addChild((UIElement)noMobs);
        } else {
            for (Map.Entry<Integer, Spawner> entry : this.mobSpawner.spawnerList.entrySet()) {
                final Spawner spawner = entry.getValue();
                int mobID = entry.getKey();
                UIElement listingPanel = new UIElement();
                listingPanel.style.height.set(50.0f);
                listingPanel.style.marginTop.set(4.0f);
                listingPanel.style.marginLeft.set(10.0f);
                listingPanel.style.marginRight.set(4.0f);
                listingPanel.setVisible(true);
                listingPanel.setClickable(false);
                listingPanel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
                listingPanel.setBorder(1.5f);
                listingPanel.setBorderEdgeRadius(10.0f, false);
                UILabel mob = new UILabel("MobID: " + String.valueOf(mobID));
                mob.setSize(10.0f, 20.0f, true);
                mob.setPosition(25.0f, 25.0f, true);
                mob.setFontSize(18.0f);
                mob.setPivot(Pivot.MiddleCenter);
                mob.setVisible(true);
                mob.setPickable(false);
                mob.setTextAlign(TextAnchor.MiddleCenter);
                UILabel mobAmount = new UILabel(String.valueOf(spawner.spawned + "/" + String.valueOf(spawner.amount)));
                mobAmount.setSize(10.0f, 20.0f, true);
                mobAmount.setPosition(25.0f, 75.0f, true);
                mobAmount.setFontSize(18.0f);
                mobAmount.setPivot(Pivot.MiddleCenter);
                mobAmount.setVisible(true);
                mobAmount.setPickable(false);
                mobAmount.setTextAlign(TextAnchor.MiddleCenter);
                this.killMob = new UILabel("Destroy"){

                    public void onClick(PlayerUIElementClickEvent event) {
                        spawner.killMob(SpawnerUI.this.spawnUI, event.getPlayer());
                        event.getPlayer().removeUIElement(SpawnerUI.this.killMob.getParent());
                    }
                };
                this.killMob.setSize(20.0f, 50.0f, true);
                this.killMob.setPosition(50.0f, 50.0f, true);
                this.killMob.setFontSize(18.0f);
                this.killMob.setPivot(Pivot.MiddleCenter);
                this.killMob.setVisible(true);
                this.killMob.setClickable(true);
                this.killMob.setBorder(1.5f);
                this.killMob.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
                this.killMob.setBackgroundColor(1.0f, 0.0f, 0.0f, 1.0f);
                this.killMob.setBorderEdgeRadius(10.0f, false);
                this.killMob.setTextAlign(TextAnchor.MiddleCenter);
                UILabel tpMob = new UILabel("TP"){

                    public void onClick(PlayerUIElementClickEvent event) {
                        SpawnerUI.this.player.setPosition(spawner.position);
                    }
                };
                tpMob.setSize(20.0f, 50.0f, true);
                tpMob.setPosition(75.0f, 50.0f, true);
                tpMob.setFontSize(18.0f);
                tpMob.setPivot(Pivot.MiddleCenter);
                tpMob.setVisible(true);
                tpMob.setClickable(true);
                tpMob.setBorder(1.5f);
                tpMob.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
                tpMob.setBackgroundColor(1.0f, 1.0f, 0.0f, 1.0f);
                tpMob.setBorderEdgeRadius(10.0f, false);
                tpMob.setTextAlign(TextAnchor.MiddleCenter);
                listingPanel.addChild((UIElement)mob);
                listingPanel.addChild((UIElement)mobAmount);
                listingPanel.addChild((UIElement)this.killMob);
                listingPanel.addChild((UIElement)tpMob);
                this.spawnScroll.addChild(listingPanel);
            }
        }
    }
}

