/*
 * Decompiled with CFR 0.152.
 */
package mobspawner;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import mobspawner.MobSpawner;
import mobspawner.SpawnerUI;
import net.risingworld.api.Internals;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class Spawner {
    public MobSpawner mobSpawner;
    private Random random = new Random();
    public Integer mobID;
    public Integer amount;
    public Vector3f position;
    public Quaternion rotation;
    public String type;
    public Integer spawned;
    public HashMap<Long, Npc> mobNpcs;
    public Timer killTimer;
    public String spawnedBy;

    public Spawner(MobSpawner mobSpawner, String type, Integer amount, Vector3f position, Quaternion rotation, Player player) {
        this.mobSpawner = mobSpawner;
        this.amount = amount;
        this.position = position;
        this.rotation = rotation;
        this.type = type;
        this.mobID = World.getNextNpcGroupID();
        this.spawned = 0;
        mobSpawner.spawnerList.put(this.mobID, this);
        this.mobNpcs = new HashMap();
        this.spawnedBy = player.getName();
        if (type.equalsIgnoreCase("Mixed")) {
            this.spawnMixedMob();
            return;
        }
        this.spawnMob();
        Internals.println((String)("[MobSpawner] " + type + " " + amount.toString() + " " + position.toString() + " " + rotation.toString()), (int)10);
    }

    private void spawnMob() {
        Integer n;
        Npc npc;
        int varToSpawn;
        if (this.type.equalsIgnoreCase("Bandit")) {
            while (this.amount - 1 >= this.spawned) {
                varToSpawn = this.random.nextInt(0, this.mobSpawner.mobSpawnerSettings.banditVars);
                npc = World.spawnNpc((short)this.mobSpawner.mobSpawnerSettings.banditId, (int)varToSpawn, (Vector3f)this.position, (Quaternion)this.rotation, (boolean)true);
                npc.setGroupID(this.mobID.intValue());
                this.mobNpcs.put(npc.getGlobalID(), npc);
                npc.setAttribute("Spawner", (Object)this);
                npc.setAlerted(true, 10);
                n = this.spawned;
                this.spawned = this.spawned + 1;
            }
        }
        if (this.type.equalsIgnoreCase("Barbarian")) {
            while (this.amount - 1 >= this.spawned) {
                varToSpawn = this.random.nextInt(0, this.mobSpawner.mobSpawnerSettings.barbarianVars);
                npc = World.spawnNpc((short)this.mobSpawner.mobSpawnerSettings.barbarianId, (int)varToSpawn, (Vector3f)this.position, (Quaternion)this.rotation, (boolean)true);
                npc.setGroupID(this.mobID.intValue());
                this.mobNpcs.put(npc.getGlobalID(), npc);
                npc.setAttribute("Spawner", (Object)this);
                npc.setAlerted(true, 10);
                n = this.spawned;
                this.spawned = this.spawned + 1;
            }
        }
        if (this.type.equalsIgnoreCase("Skeleton")) {
            while (this.amount - 1 >= this.spawned) {
                varToSpawn = this.random.nextInt(0, this.mobSpawner.mobSpawnerSettings.skeletonVars);
                npc = World.spawnNpc((short)this.mobSpawner.mobSpawnerSettings.skeletonId, (int)varToSpawn, (Vector3f)this.position, (Quaternion)this.rotation, (boolean)true);
                npc.setGroupID(this.mobID.intValue());
                this.mobNpcs.put(npc.getGlobalID(), npc);
                npc.setAttribute("Spawner", (Object)this);
                npc.setAlerted(true, 10);
                n = this.spawned;
                this.spawned = this.spawned + 1;
            }
        }
        if (this.type.equalsIgnoreCase("Ghoul")) {
            while (this.amount - 1 >= this.spawned) {
                Npc npc2 = World.spawnNpc((short)this.mobSpawner.mobSpawnerSettings.ghoulId, (int)0, (Vector3f)this.position, (Quaternion)this.rotation, (boolean)true);
                npc2.setGroupID(this.mobID.intValue());
                this.mobNpcs.put(npc2.getGlobalID(), npc2);
                npc2.setAttribute("Spawner", (Object)this);
                npc2.setAlerted(true, 10);
                Integer n2 = this.spawned;
                this.spawned = this.spawned + 1;
            }
        }
    }

    private void spawnMixedMob() {
    }

    public void npcDeath(Npc npc) {
        Internals.println((String)("[MobSpawner] Npc died " + String.valueOf(npc.getGlobalID())), (int)10);
        this.mobNpcs.remove(npc.getGlobalID());
        Integer n = this.spawned;
        this.spawned = this.spawned - 1;
        Internals.println((String)("[MobSpawner] Mob: " + String.valueOf(this.mobID) + " Has " + String.valueOf(this.spawned) + " Npcs Remaining"), (int)10);
        if (this.spawned == 0) {
            this.mobDefeated();
        }
    }

    private void mobDefeated() {
        Internals.println((String)("[MobSpawner] Mob: " + String.valueOf(this.mobID) + " Defeated"), (int)10);
        this.mobSpawner.spawnerList.remove(this.mobID);
    }

    public void killMob(SpawnerUI spawnerUI, Player player) {
        if (this.killTimer == null) {
            Internals.println((String)("[MobSpawner] Destroying  Mob: " + String.valueOf(this.mobID)), (int)10);
            this.killTimer = new Timer(1.5f, 0.0f, -1, () -> {
                Iterator<Map.Entry<Long, Npc>> iterator = this.mobNpcs.entrySet().iterator();
                Map.Entry<Long, Npc> firstEntry = iterator.next();
                firstEntry.getValue().kill();
                this.mobNpcs.remove(firstEntry.getKey());
                if (this.mobNpcs.isEmpty()) {
                    this.killTimer.kill();
                }
                spawnerUI.refresh();
            });
            this.killTimer.start();
        } else {
            player.showStatusMessage("Mob already being destroyed", 5);
        }
    }

    public void mobUI(UIElement spawnerUI) {
    }
}

