/*
 * Decompiled with CFR 0.152.
 */
package mobspawner;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import mobspawner.MobSpawner;
import net.risingworld.api.assets.TextureAsset;

public class MobSpawnerSettings {
    private MobSpawner mobSpawner;
    private Properties properties;
    public List<String> types;
    public int banditVars;
    public short banditId;
    public int barbarianVars;
    public short barbarianId;
    public int skeletonVars;
    public short skeletonId;
    public int ghoulVars;
    public short ghoulId;
    public TextureAsset background;

    public MobSpawnerSettings(MobSpawner mobSpawner) {
        this.mobSpawner = mobSpawner;
        this.loadSettings();
    }

    public void loadSettings() {
        this.properties = new Properties();
        try (FileInputStream input = new FileInputStream(this.mobSpawner.getPath() + "/MobSettings.properties");){
            this.properties.load(input);
            String[] typesNames = this.properties.getProperty("types").split(",");
            this.types = Arrays.asList(typesNames);
            String[] banditString = this.properties.getProperty("bandit").split(",");
            this.banditVars = Integer.parseInt(banditString[0]);
            this.banditId = Short.parseShort(banditString[1]);
            String[] barbarianString = this.properties.getProperty("barbarian").split(",");
            this.barbarianVars = Integer.parseInt(barbarianString[0]);
            this.barbarianId = Short.parseShort(barbarianString[1]);
            String[] skeletonString = this.properties.getProperty("skeleton").split(",");
            this.skeletonVars = Integer.parseInt(skeletonString[0]);
            this.skeletonId = Short.parseShort(skeletonString[1]);
            String[] ghoulString = this.properties.getProperty("ghoul").split(",");
            this.ghoulVars = Integer.parseInt(ghoulString[0]);
            this.ghoulId = Short.parseShort(ghoulString[1]);
            this.background = TextureAsset.loadFromFile((String)(this.mobSpawner.getPath() + "/background.jpg"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.finishedLoading();
    }

    private void finishedLoading() {
        this.mobSpawner.settingsLoaded(this);
    }
}

