/*
 * Decompiled with CFR 0.152.
 */
package adminswitch;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import net.risingworld.api.Internals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;

public class AdminSwitch
extends Plugin
implements Listener {
    ArrayList<String> canSwitch;
    Properties properties;
    String switchCommand;
    String listCommand;

    public void onEnable() {
        this.canSwitch = new ArrayList();
        this.registerEventListener(this);
        this.loadSettings();
    }

    public void onDisable() {
    }

    private void loadSettings() {
        this.properties = new Properties();
        try (FileInputStream file = new FileInputStream(this.getPath() + "/Switch.properties");){
            this.properties.load(file);
            String[] ids = this.properties.getProperty("UIDS").split(",");
            Collections.addAll(this.canSwitch, ids);
            this.switchCommand = this.properties.getProperty("SwitchCommand", "Switch");
            this.listCommand = this.properties.getProperty("ListCommand", "List");
            Internals.println((String)("[AdminSwitch] Allowed Users: " + String.valueOf(this.canSwitch)), (int)10);
            Internals.println((String)("[AdminSwitch] Switch Command : /" + this.switchCommand), (int)10);
            Internals.println((String)("[AdminSwitch] List Command: /" + this.listCommand), (int)10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @EventMethod
    public void command(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        if (this.canSwitch.contains(player.getUID())) {
            String[] groups;
            String[] cmd = event.getCommand().split(" ");
            if (cmd.length == 1) {
                if (cmd[0].equalsIgnoreCase("/" + this.switchCommand)) {
                    if (player.isAdmin()) {
                        Server.sendInputCommand((String)("revokeadmin " + player.getUID()));
                        return;
                    }
                    if (!player.isAdmin()) {
                        Server.sendInputCommand((String)("makeadmin " + player.getUID()));
                    }
                }
                if (cmd[0].equalsIgnoreCase("/" + this.listCommand)) {
                    for (String groupName : groups = Server.getAllPermissionGroups()) {
                        player.sendTextMessage(groupName);
                    }
                }
            }
            if (cmd.length == 2) {
                groups = Server.getAllPermissionGroups();
                ArrayList<String> permissionGroups = new ArrayList<String>(Arrays.asList(groups));
                if (permissionGroups.contains(cmd[1])) {
                    player.setPermissionGroup(cmd[1]);
                    if (player.isAdmin()) {
                        Server.sendInputCommand((String)("revokeadmin " + player.getUID()));
                        return;
                    }
                    if (!player.isAdmin()) {
                        Server.sendInputCommand((String)("makeadmin " + player.getUID()));
                    }
                } else {
                    player.sendTextMessage("Invalid command");
                }
            }
            if (cmd.length > 2) {
                player.sendTextMessage("Invalid command");
            }
        }
    }
}

