/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import com.example.risingworld.discordadmin.PluginLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;

public class FileUtils {
    public static boolean ensureDirectoryExists(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return directory.isDirectory();
        }
        try {
            Path path = directory.toPath();
            Files.createDirectories(path, new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            try {
                return directory.mkdirs();
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static boolean ensureParentDirectoryExists(File file) {
        if (file == null) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return true;
        }
        return FileUtils.ensureDirectoryExists(parent);
    }

    public static boolean createEmptyFile(File file, PluginLogger logger) {
        if (file == null) {
            return false;
        }
        if (!FileUtils.ensureParentDirectoryExists(file)) {
            if (logger != null) {
                logger.warning("Failed to create parent directory for: " + file.getAbsolutePath());
            }
            return false;
        }
        try {
            if (!file.exists()) {
                return file.createNewFile();
            }
            return true;
        }
        catch (IOException e) {
            if (logger != null) {
                logger.log(Level.WARNING, "Failed to create file: " + file.getAbsolutePath(), e);
            }
            return false;
        }
    }

    public static File resolveFile(String basePath, String relativePath) {
        if (basePath == null || relativePath == null) {
            return null;
        }
        Path base = Paths.get(basePath, new String[0]).normalize();
        Path path = base.resolve(relativePath).normalize();
        return path.toFile();
    }
}

