/*
 * Decompiled with CFR 0.152.
 */
package com.example.risingworld.discordadmin;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.risingworld.api.Plugin;

public class DiscordAdminPlugin
extends Plugin {
    private SimpleLogger logger;
    private Plugin realPlugin;
    private Object libraryLoader;
    private boolean initialized = false;
    private final AtomicBoolean dependenciesAvailable = new AtomicBoolean(false);
    private ScheduledExecutorService dependencyChecker;
    private Runnable dependencyCallback = null;

    @Override
    public void onEnable() {
        this.logger = new SimpleLogger(this.getName());
        this.logger.info("Bootstrap starting for Discord Admin Plugin v3.5.0");
        try {
            boolean libLoaderAvailable;
            File libDir = new File(this.getPath(), "lib");
            if (!libDir.exists()) {
                libDir.mkdirs();
                this.logger.info("Created lib directory at: " + libDir.getAbsolutePath());
            }
            if (!(libLoaderAvailable = this.ensureLibraryLoaderAvailable())) {
                this.logger.severe("Cannot load core LibraryLoader class");
                return;
            }
            this.libraryLoader = this.createLibraryLoader();
            if (this.libraryLoader == null) {
                this.logger.severe("Failed to create LibraryLoader instance");
                return;
            }
            this.startDependencyChecker();
            this.setDependencyCallback();
            boolean depsAvailable = this.callInitializeMethod();
            this.dependenciesAvailable.set(depsAvailable);
            if (depsAvailable) {
                this.logger.info("All dependencies available, initializing plugin now");
                this.initializeRealPlugin();
            } else {
                this.logger.info("Waiting for dependencies to be available before plugin initialization...");
                this.logger.info("The plugin will start automatically once all dependencies are available.");
            }
        }
        catch (Throwable t) {
            this.logger.severe("Error in bootstrap: " + t.getMessage());
            t.printStackTrace();
        }
    }

    private void startDependencyChecker() {
        this.dependencyChecker = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "DependencyChecker");
            t.setDaemon(true);
            return t;
        });
        this.dependencyChecker.scheduleAtFixedRate(() -> {
            try {
                if (!this.dependenciesAvailable.get() && this.libraryLoader != null) {
                    this.logger.info("Checking for dependencies availability...");
                    Method checkMethod = this.libraryLoader.getClass().getMethod("checkDependencies", new Class[0]);
                    Boolean result = (Boolean)checkMethod.invoke(this.libraryLoader, new Object[0]);
                    if (result.booleanValue()) {
                        this.logger.info("All required dependencies are now available!");
                        this.dependenciesAvailable.set(true);
                        if (!this.initialized && this.dependencyCallback != null) {
                            this.dependencyCallback.run();
                        }
                    } else {
                        this.logger.info("Still waiting for dependencies to become available.");
                    }
                }
            }
            catch (Exception e) {
                this.logger.warning("Error checking dependencies: " + e.getMessage());
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    private boolean ensureLibraryLoaderAvailable() {
        try {
            try {
                Class.forName("com.example.risingworld.discordadmin.LibraryLoader");
                this.logger.info("LibraryLoader class already available");
                return true;
            }
            catch (ClassNotFoundException e) {
                this.logger.info("Need to manually load LibraryLoader class");
                File pluginJar = this.getPluginJarFile();
                if (pluginJar == null || !pluginJar.exists()) {
                    this.logger.severe("Cannot find plugin JAR file to load LibraryLoader class");
                    return false;
                }
                URLClassLoader classLoader = (URLClassLoader)this.getClass().getClassLoader();
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)classLoader, pluginJar.toURI().toURL());
                try {
                    Class.forName("com.example.risingworld.discordadmin.LibraryLoader");
                    this.logger.info("Successfully loaded LibraryLoader class from plugin JAR");
                    return true;
                }
                catch (ClassNotFoundException e2) {
                    this.logger.severe("LibraryLoader class not found in plugin JAR");
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Error ensuring LibraryLoader is available: " + e.getMessage());
            return false;
        }
    }

    private File getPluginJarFile() {
        try {
            String className = this.getClass().getName().replace('.', '/') + ".class";
            URL url = this.getClass().getClassLoader().getResource(className);
            if (url == null) {
                return null;
            }
            String urlStr = url.toString();
            if (urlStr.startsWith("jar:file:")) {
                String jarPath = urlStr.substring(9, urlStr.indexOf(33));
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
                return new File(jarPath);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.severe("Error getting plugin JAR file: " + e.getMessage());
            return null;
        }
    }

    private Object createLibraryLoader() {
        try {
            Class<?> libLoaderClass = Class.forName("com.example.risingworld.discordadmin.LibraryLoader");
            Object pluginLogger = this.createPluginLogger();
            return libLoaderClass.getDeclaredConstructor(Class.forName("com.example.risingworld.discordadmin.PluginLogger"), String.class).newInstance(pluginLogger, this.getPath());
        }
        catch (Exception e) {
            this.logger.severe("Error creating LibraryLoader: " + e.getMessage());
            return null;
        }
    }

    private void setDependencyCallback() {
        try {
            if (this.libraryLoader == null) {
                return;
            }
            Class<?> libLoaderClass = this.libraryLoader.getClass();
            Method setCallbackMethod = libLoaderClass.getMethod("setDependencyCallback", Runnable.class);
            this.dependencyCallback = () -> {
                this.logger.info("Dependency callback triggered, initializing full plugin functionality");
                if (!this.initialized) {
                    this.initializeRealPlugin();
                } else {
                    this.logger.info("Plugin already initialized, enabling additional features");
                    try {
                        Method enableFullFeaturesMethod;
                        if (this.realPlugin != null && (enableFullFeaturesMethod = this.realPlugin.getClass().getMethod("enableFullFeatures", new Class[0])) != null) {
                            enableFullFeaturesMethod.invoke((Object)this.realPlugin, new Object[0]);
                            this.logger.info("Full features enabled successfully");
                        }
                    }
                    catch (Exception e) {
                        this.logger.warning("Could not enable full features: " + e.getMessage() + " (this is normal if the plugin doesn't support dynamic feature enabling)");
                    }
                }
            };
            setCallbackMethod.invoke(this.libraryLoader, this.dependencyCallback);
            this.logger.info("Dependency callback set successfully");
        }
        catch (Exception e) {
            this.logger.warning("Failed to set dependency callback: " + e.getMessage() + " (this is normal if using an older version of LibraryLoader)");
        }
    }

    private boolean callInitializeMethod() {
        try {
            if (this.libraryLoader == null) {
                return false;
            }
            Method initMethod = this.libraryLoader.getClass().getMethod("initialize", new Class[0]);
            Object result = initMethod.invoke(this.libraryLoader, new Object[0]);
            if (result instanceof Boolean) {
                boolean depsAvailable = (Boolean)result;
                if (!depsAvailable) {
                    try {
                        Method reportMethod = this.libraryLoader.getClass().getMethod("generateEnvironmentReport", new Class[0]);
                        String report = (String)reportMethod.invoke(this.libraryLoader, new Object[0]);
                        this.logger.info("Environment Report:\n" + report);
                        File reportFile = new File(this.getPath(), "environment_report.txt");
                        try (FileOutputStream fos = new FileOutputStream(reportFile);){
                            fos.write(report.getBytes());
                        }
                        this.logger.info("Saved environment report to: " + reportFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        this.logger.warning("Failed to generate environment report: " + e.getMessage());
                    }
                }
                return depsAvailable;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.severe("Failed to initialize dependencies: " + e.getMessage());
            return false;
        }
    }

    private Object createPluginLogger() {
        try {
            Class<?> loggerClass = Class.forName("com.example.risingworld.discordadmin.PluginLogger");
            return loggerClass.getDeclaredConstructor(String.class).newInstance(this.getName());
        }
        catch (Exception e) {
            this.logger.severe("Error creating PluginLogger: " + e.getMessage());
            return null;
        }
    }

    private synchronized void initializeRealPlugin() {
        if (this.initialized) {
            return;
        }
        try {
            this.logger.info("Initializing real plugin implementation");
            if (this.realPlugin == null) {
                this.createPluginInstance();
            }
            if (this.realPlugin == null) {
                this.logger.severe("Cannot initialize real plugin: failed to create plugin instance");
                return;
            }
            this.realPlugin.onEnable();
            this.initialized = true;
            this.logger.info("Real plugin implementation initialized successfully");
        }
        catch (Exception e) {
            this.logger.severe("Failed to initialize real plugin: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createPluginInstance() {
        try {
            Class<?> pluginClass = Class.forName("com.example.risingworld.discordadmin.DiscordAdminPluginImpl");
            Constructor<?> pathConstructor = null;
            try {
                pathConstructor = pluginClass.getDeclaredConstructor(File.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (pathConstructor != null) {
                this.realPlugin = (Plugin)pathConstructor.newInstance(new File(this.getPath()));
                this.logger.info("Created plugin instance with path constructor");
            } else {
                this.realPlugin = (Plugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.logger.info("Created plugin instance with default constructor");
                try {
                    Method setPathMethod = pluginClass.getMethod("setPluginPath", String.class);
                    setPathMethod.invoke((Object)this.realPlugin, this.getPath());
                    this.logger.info("Set plugin path using setter method");
                }
                catch (Exception e) {
                    this.logger.warning("Could not set plugin path: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to create plugin instance: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onDisable() {
        if (this.dependencyChecker != null) {
            this.dependencyChecker.shutdown();
            try {
                this.dependencyChecker.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.libraryLoader != null) {
            try {
                Method shutdownMethod = this.libraryLoader.getClass().getMethod("shutdown", new Class[0]);
                shutdownMethod.invoke(this.libraryLoader, new Object[0]);
                this.logger.info("Library loader shutdown completed");
            }
            catch (Exception e) {
                this.logger.warning("Failed to shutdown LibraryLoader: " + e.getMessage());
            }
        }
        if (this.realPlugin != null) {
            try {
                this.realPlugin.onDisable();
                this.logger.info("Real plugin disabled successfully");
            }
            catch (Exception e) {
                this.logger.severe("Error disabling real plugin: " + e.getMessage());
            }
        }
        this.logger.info("Discord Admin Bootstrap disabled");
    }

    @Override
    public String getName() {
        return "Discord Admin Integration";
    }

    public String getVersion() {
        return "3.5.0-bootstrap";
    }

    public String getDescription() {
        return "Integrates Rising World admin commands with Discord";
    }

    public String getAuthor() {
        return "Devyn";
    }

    private static class SimpleLogger {
        private final String pluginName;

        public SimpleLogger(String pluginName) {
            this.pluginName = pluginName;
        }

        public void info(String message) {
            this.log("INFO", message);
        }

        public void warning(String message) {
            this.log("WARNING", message);
        }

        public void severe(String message) {
            this.log("SEVERE", message);
        }

        private void log(String level, String message) {
            System.out.println("[" + this.pluginName + "] " + level + ": " + message);
        }
    }
}

